FILL_IN_COLUMN = 3

DOI_ROW = 2
PROJECT_NAME = 3
COUNTRY = 4
LATITUDE = 5
LONGITUDE = 6
STATUS = 7
PROJECT_DESCRIPTION = 8
SITE_DESCRIPTION = 9
START_DATE_ROW = 10
END_DATE_ROW = 11
PUBLISH_DATE = 12
LICENSE_TYPE = 13
LICENSE_LINK = 14
EXTERNAL_PROJECT_LINK = 15
ADDITIONAL_INFO_LINK = 16
KEYWORDS = 17

ORIGINAL_DEVICE_SECTION = 19
DEVICE_SECTION_LENGTH = 4
DEVICE_NAME_ROW_OFFSET = 0
DEVICE_TYPE_ROW_OFFSET = 1
DEVICE_DATA_TYPE_OFFSET = 2

ORIGINAL_DATA_SET_SECTION = 24
DATA_SET_SECTION_LENGTH = 7
DATA_SET_TYPE_OFFSET = 0
LATITUDE_TOP_LEFT_OFFSET = 1
LONGITUDE_TOP_LEFT_OFFSET = 2
LATITUDE_BOTTOM_RIGHT_OFFSET = 3
LONGITUDE_BOTTOM_RIGHT_OFFSET = 4
SIZE_OFFSET = 5

ORIGINAL_ORGANIZATIONS_SECTION = 32
ORGANIZATION_SECTION_LENGTH = 4
ORGANIZATION_NAME_OFFSET = 0
ORGANIZATION_URL_OFFSET = 1
ENTITY_TYPE_OFFSET = 2


class Entity:
    name: str
    link: str
    type: str

    def __init__(self):
        self.name = ""
        self.link = ""
        self.type = ""


class Dataset:
    device_name: str
    device_type: str
    data_type: str
    top_left_latitude: float
    top_left_longitude: float
    bottom_right_latitude: float
    bottom_right_longitude: float
    data_size: float

    def __init__(self):
        self.device_name = ""
        self.device_type = ""
        self.data_type = ""
        self.top_left_latitude = 0
        self.top_left_longitude = 0
        self.bottom_right_latitude = 0
        self.bottom_right_longitude = 0
        self.data_size = 0


class Project:
    doi: str
    name: str
    country: str
    latitude: float
    longitude: float
    status: str
    project_description: str
    site_description: str
    collection_date_start: str
    collection_date_end: str
    publish_date: str
    license_type: str
    license_link: str
    external_project_link: str
    additional_info_link: str
    keywords: str

    datasets: list[Dataset]
    entities: list[Entity]

    def __init__(self):
        self.doi = ""
        self.name = ""
        self.country = ""
        self.latitude: 0
        self.longitude: 0
        self.status = ""
        self.project_description = ""
        self.site_description = ""
        self.collection_date_start = ""
        self.collection_date_end = ""
        self.publish_date = ""
        self.license_type = ""
        self.license_link = ""
        self.external_project_link = ""
        self.additional_info_link = ""
        self.keywords = ""

    @staticmethod
    def get_license_link(license_type: str) -> str:
        license_link = ""
        if license_type == "CC BY":
            license_link = "https://creativecommons.org/licenses/by/4.0"
        elif license_type == "CC BY-SA":
            license_link = "https://creativecommons.org/licenses/by-sa/4.0"
        elif license_type == "CC BY-ND":
            license_link = "https://creativecommons.org/licenses/by-nd/4.0"
        elif license_type == "CC BY-NC":
            license_link = "https://creativecommons.org/licenses/by-nc/4.0"
        elif license_type == "CC BY-NC-SA":
            license_link = "https://creativecommons.org/licenses/by-nc-sa/4.0"
        elif license_type == "CC BY-NC-ND":
            license_link = "https://creativecommons.org/licenses/by-nc-nd/4.0"

        return license_link
