import sys
import mysql_uploader
import doi_uploader
import os


def upload_directory(directory_path: str) -> None:
    """
    Uploads all of the files in the given directory to datacite and then the OpenHeritage HeidiSQL database.

    :param directory_path: The path of the directory, which contains the files to be uploaded
    :return: None
    """
    for filename in os.listdir(directory_path):
        if filename.endswith(".csv"):
            file_path = os.path.join(directory_path, filename)

            print(file_path)

            upload_file(file_path)


def upload_file(file_path: str) -> None:
    """
    Uploads the file located at the given file path to datacite and then the OpenHeritage HeidiSQL database.

    :param file_path: The path of the file to be uploaded
    :return: None
    """
    if doi_uploader.upload_doi_draft(file_path):
        mysql_uploader.main(file_path)


if __name__== "__main__":
    if len(sys.argv) == 2:
        target_path = sys.argv[1]
        if os.path.isdir(target_path):
            upload_directory(target_path)
        else:
            upload_file(target_path)
    else:
        raise ValueError("Error: Wrong Usage!")




