# Performance Comparison: Containers

> **<span style="color:red">This file is auto-generated</span>**
> 
> All measurments were taken on Intel(R) Core(TM) i9-9900KS CPU @ 4.00GHz with 16 logical cores.<br/>
> Unity Editor version: 2022.3.6f1<br/>
> To regenerate this file locally use: **DOTS -> Unity.Collections -> Generate &ast;&ast;&ast;** menu.<br/>

## Table of Contents

- [Benchmark Results](#benchmark-results)
  - [HashMap](#hashmap)
  - [HashSet](#hashset)
  - [List](#list)
  - [ParallelHashMap](#parallelhashmap)
  - [ParallelHashSet](#parallelhashset)
  - [QueueParallelWriter](#queueparallelwriter)
  - [Queue](#queue)
  - [RingQueue](#ringqueue)

## Benchmark Results

The **Median of 10 sample sets** is compared against the baseline on the far right side of the table.<br/>Multithreaded benchmarks divide the processing amongst the specified number of workers.<br/>5 extra sample sets are run as warmup.<br/>
<br/>

> **Legend**
> 
> `(S)` = Safety Enabled<br/>
> `(B)` = Burst Compiled *with Safety Disabled*<br/>
> `(S+B)` = Burst Compiled *with Safety Enabled*<br/>
> `(BCL)` = Base Class Library implementation (such as provided by Mono or .NET)<br/>
> <br/>
> *`italic`* results are for benchmarking comparison only; these are not included in standard Performance Framework tests<br/>

<br/>

### *HashMap*

| Functionality | NativeHashMap (S) | NativeHashMap (S+B) | NativeHashMap (B) | UnsafeHashMap (S) | UnsafeHashMap (S+B) | UnsafeHashMap (B) | *Dictionary (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(0)`*¹* | 0.342ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.133ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.221ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.105ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.106ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IsEmpty_x_100k(100)`*¹* | 0.342ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.112ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.133ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.221ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(0)`*¹* | 0.261ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.142ms <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.120ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(100)`*¹* | 0.261ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.142ms <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.120ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArrayKeys(10000)` | 0.151ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.126ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.092ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.159ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 0.125ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.083ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.018ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `ToNativeArrayKeys(100000)` | 1.659ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 1.214ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.918ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.610ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.205ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.908ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.174ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `ToNativeArrayKeys(1000000)` | 21.689ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 13.624ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.721ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.842ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 13.505ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.569ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.059ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `ToNativeArrayValues(10000)` | 0.160ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.118ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.086ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 0.125ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.018ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `ToNativeArrayValues(100000)` | 1.702ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.192ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.935ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.721ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 1.196ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.919ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.173ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `ToNativeArrayValues(1000000)` | 20.402ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 13.609ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.017ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 20.556ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 13.773ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.869ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.018ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Insert(10000)` | 0.135ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.070ms <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.061ms <span style="color:green">(2.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.120ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.060ms <span style="color:green">(2.9x)</span>&nbsp;🟢 | 0.061ms <span style="color:green">(2.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.175ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(100000)` | 1.723ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.996ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.914ms <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.565ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.909ms <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.889ms <span style="color:green">(2.5x)</span>&nbsp;🟢 | *2.209ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1000000)` | 33.017ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 21.056ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.847ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 50.228ms <span style="color:red">(0.6x)</span>&nbsp;🟠 | 19.654ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.613ms <span style="color:green">(1.5x)</span>&nbsp;🟢 | *29.738ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `AddGrow(4, 1048576)`*³* | 137.459ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 81.364ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 77.039ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 133.603ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 78.458ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 76.533ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *49.222ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `AddGrow(65536, 1048576)`*³* | 140.883ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 82.611ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 77.670ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 134.717ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 79.913ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 77.316ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *50.215ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Contains(10000)` | 0.089ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.027ms <span style="color:green">(6.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.101ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.029ms <span style="color:green">(6.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.025ms <span style="color:green">(7.4x)</span>&nbsp;🟢 | *0.188ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(100000)` | 1.696ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.694ms <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.508ms <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.945ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.538ms <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.482ms <span style="color:green">(5.9x)</span>&nbsp;🟢 | *2.843ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1000000)` | 42.805ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.135ms <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.633ms <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 43.284ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.700ms <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.703ms <span style="color:green">(5.3x)</span>&nbsp;🟢 | *62.072ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(10000)` | 0.109ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.028ms <span style="color:green">(6.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.032ms <span style="color:green">(5.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.122ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.027ms <span style="color:green">(7.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.026ms <span style="color:green">(7.1x)</span>&nbsp;🟢 | *0.189ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(100000)` | 1.983ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.592ms <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.614ms <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.125ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.543ms <span style="color:green">(5.1x)</span>&nbsp;🟢 | 0.545ms <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.791ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(1000000)` | 57.739ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.881ms <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.937ms <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 57.860ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 14.918ms <span style="color:green">(4.1x)</span>&nbsp;🟢 | 15.113ms <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *61.850ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(10000)` | 0.103ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.080ms <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.040ms <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.039ms <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms <span style="color:green">(5.8x)</span>&nbsp;🟢 | *0.209ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(100000)` | 1.890ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.269ms <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.755ms <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.473ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.759ms <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.707ms <span style="color:green">(4.3x)</span>&nbsp;🟢 | *3.074ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(1000000)` | 73.370ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 69.054ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 65.695ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 73.500ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 65.870ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 66.574ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *73.729ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(10000)` | 0.105ms <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.033ms <span style="color:green">(5.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.032ms <span style="color:green">(5.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.120ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.029ms <span style="color:green">(6.6x)</span>&nbsp;🟢 | 0.029ms <span style="color:green">(6.6x)</span>&nbsp;🟢 | *0.191ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(100000)` | 1.943ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.645ms <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.637ms <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.102ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.574ms <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.557ms <span style="color:green">(5.1x)</span>&nbsp;🟢 | *2.816ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(1000000)` | 55.056ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.084ms <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.878ms <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 59.138ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.889ms <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.692ms <span style="color:green">(4.0x)</span>&nbsp;🟢 | *62.067ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(10000)` | 0.110ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.044ms <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.035ms <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.094ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.029ms <span style="color:green">(5.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.028ms <span style="color:green">(5.6x)</span>&nbsp;🟢 | *0.158ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(100000)` | 1.889ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.844ms <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.661ms <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.654ms <span style="color:red">(0.7x)</span>&nbsp;🟠 | 0.566ms <span style="color:green">(4.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.547ms <span style="color:green">(4.4x)</span>&nbsp;🟢 | *2.395ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Remove(1000000)` | 62.623ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 56.372ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 53.877ms <span style="color:green">(1.2x)</span>&nbsp;🟢 | 61.104ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 54.841ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 55.805ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *62.915ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(10000)` | 0.150ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.083ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.077ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.141ms <span style="color:red">(0.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.077ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.079ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.041ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Foreach(100000)` | 1.984ms <span style="color:red">(0.2x)</span>&nbsp;🟠 | 0.924ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.866ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.869ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.865ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.885ms <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.412ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Foreach(1000000)` | 27.605ms <span style="color:red">(0.2x)</span>&nbsp;🟠 | 10.947ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.421ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 26.351ms <span style="color:red">(0.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.457ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.619ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *4.359ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |

*¹* Optimizations were disabled to perform this benchmark<br/>
*³* AddGrow(capacity, growTo) -- Incrementally grows from `capacity` until reaching size of `growTo`<br/>

---
<br/>

### *HashSet*

| Functionality | NativeHashSet (S) | NativeHashSet (S+B) | NativeHashSet (B) | UnsafeHashSet (S) | UnsafeHashSet (S+B) | UnsafeHashSet (B) | *HashSet (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(0)`*¹* | 0.342ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.112ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.133ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.221ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms <span style="color:green">(1.3x)</span>&nbsp;🟢 | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IsEmpty_x_100k(100)`*¹* | 0.342ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.112ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.133ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.221ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;🟢 | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(0)`*¹* | 0.261ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.143ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.100ms <span style="color:green">(1.4x)</span>&nbsp;🟢 | 0.111ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(100)`*¹* | 0.261ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.142ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.100ms <span style="color:green">(1.4x)</span>&nbsp;🟢 | 0.111ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(10000)` | 0.043ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.015ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.043ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.015ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms  <span style="color:green">(1.9x)</span>&nbsp;🟢 | *0.018ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(100000)` | 0.475ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.144ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.085ms  <span style="color:green">(2.1x)</span>&nbsp;🟢 | 0.485ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.144ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.085ms  <span style="color:green">(2.1x)</span>&nbsp;🟢 | *0.176ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(1000000)` | 4.935ms <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.591ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.989ms  <span style="color:green">(1.9x)</span>&nbsp;🟢 | 5.378ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 1.586ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.997ms  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.927ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Insert(10000)` | 0.093ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.044ms <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.040ms  <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.078ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.039ms <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.035ms  <span style="color:green">(2.9x)</span>&nbsp;🟢 | *0.103ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(100000)` | 0.937ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.441ms <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.403ms  <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.785ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.390ms <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.351ms  <span style="color:green">(2.9x)</span>&nbsp;🟢 | *1.029ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1000000)` | 12.275ms <span style="color:red">(0.8x)</span>&nbsp;🟠 | 7.030ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.650ms  <span style="color:green">(1.6x)</span>&nbsp;🟢 | 10.495ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.902ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.747ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *10.384ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `AddGrow(4, 1048576)`*³* | 76.515ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 35.430ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 33.171ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 75.704ms <span style="color:red">(0.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 32.776ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 30.928ms  <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *20.387ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `AddGrow(65536, 1048576)`*³* | 75.192ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 34.149ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 32.652ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 74.248ms <span style="color:red">(0.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 34.092ms <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 32.440ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *19.978ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Contains(10000)` | 0.061ms <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:green">(6.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.010ms <span style="color:green">(11.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.072ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.013ms <span style="color:green">(8.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms <span style="color:green">(12.5x)</span>&nbsp;🟢 | *0.113ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(100000)` | 0.949ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.311ms <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.199ms  <span style="color:green">(8.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.104ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.207ms <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.180ms  <span style="color:green">(8.9x)</span>&nbsp;🟢 | *1.610ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1000000)` | 11.436ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.877ms <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.576ms  <span style="color:green">(7.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 13.252ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.653ms <span style="color:green">(7.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.373ms  <span style="color:green">(8.0x)</span>&nbsp;🟢 | *19.089ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(10000)` | 0.111ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.054ms <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.044ms  <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.101ms <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms <span style="color:green">(5.2x)</span>&nbsp;🟢 | 0.040ms  <span style="color:green">(4.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.186ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(100000)` | 1.327ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.645ms <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.531ms  <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.218ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.438ms <span style="color:green">(4.7x)</span>&nbsp;🟢 | 0.477ms  <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.076ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1000000)` | 15.132ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.264ms <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 5.953ms  <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 26.197ms <span style="color:red">(0.9x)</span>&nbsp;🟠 | 4.917ms <span style="color:green">(4.7x)</span>&nbsp;🟢 | 5.268ms  <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *23.150ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(10000)` | 0.081ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.029ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.016ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | 0.054ms <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.036ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(100000)` | 0.766ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.241ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.135ms  <span style="color:green">(2.6x)</span>&nbsp;🟢 | 0.505ms <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.145ms <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.145ms  <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.356ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(1000000)` | 7.540ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 2.280ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.431ms  <span style="color:green">(2.5x)</span>&nbsp;🟢 | 4.906ms <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.524ms <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.516ms  <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.638ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `UnionWith(10000)` | 0.226ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.144ms <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.128ms  <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.191ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.119ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.116ms  <span style="color:green">(2.2x)</span>&nbsp;🟢 | *0.254ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `UnionWith(100000)` | 2.545ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.664ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.486ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.140ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.370ms <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.349ms  <span style="color:green">(2.6x)</span>&nbsp;🟢 | *3.441ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `UnionWith(1000000)` | 80.802ms <span style="color:red">(0.7x)</span>&nbsp;🟠 | 43.823ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.187ms  <span style="color:green">(1.5x)</span>&nbsp;🟢 | 74.811ms <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 45.527ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 40.115ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *59.785ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IntersectWith(10000)` | 0.246ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.142ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.123ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.201ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.107ms <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.105ms  <span style="color:green">(2.6x)</span>&nbsp;🟢 | *0.270ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IntersectWith(100000)` | 2.705ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.546ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.405ms  <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.218ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.189ms <span style="color:green">(2.9x)</span>&nbsp;🟢 | 1.231ms  <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.436ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IntersectWith(1000000)` | 33.228ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.026ms <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.066ms  <span style="color:green">(3.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 27.030ms <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 14.937ms <span style="color:green">(4.4x)</span>&nbsp;🟢 | 15.096ms  <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *65.055ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ExceptWith(10000)` | 0.212ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.125ms <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.107ms  <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.175ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.094ms <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.093ms  <span style="color:green">(2.4x)</span>&nbsp;🟢 | *0.218ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ExceptWith(100000)` | 2.374ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.419ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.257ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.992ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.109ms <span style="color:green">(2.5x)</span>&nbsp;🟢 | 1.110ms  <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.799ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ExceptWith(1000000)` | 35.627ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.482ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.001ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 29.688ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.493ms <span style="color:green">(2.6x)</span>&nbsp;🟢 | 15.620ms  <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *39.627ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*¹* Optimizations were disabled to perform this benchmark<br/>
*³* AddGrow(capacity, growTo) -- Incrementally grows from `capacity` until reaching size of `growTo`<br/>

---
<br/>

### *List*

| Functionality | NativeList (S) | NativeList (S+B) | NativeList (B) | UnsafeList (S) | UnsafeList (S+B) | UnsafeList (B) | *List (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(0)`*¹* | 0.154ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.121ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;🟢 | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;🟢 | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IsEmpty_x_100k(100)`*¹* | 0.154ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.121ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.106ms  <span style="color:green">(1.3x)</span>&nbsp;🟢 | *0.140ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(0)`*¹* | 0.120ms <span style="color:grey">(1.0x)</span>&nbsp;🟠 | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.020ms <span style="color:green">(6.0x)</span>&nbsp;🟢 | 0.081ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(100)`*¹* | 0.120ms <span style="color:grey">(1.0x)</span>&nbsp;🟠 | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.020ms <span style="color:green">(6.0x)</span>&nbsp;🟢 | 0.081ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms  <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArray(10000)` | 0.002ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms  <span style="color:green">(1.9x)</span>&nbsp;🟢 | --- | --- | --- | *0.003ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArray(100000)` | 0.088ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.015ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.015ms  <span style="color:green">(2.0x)</span>&nbsp;🟢 | --- | --- | --- | *0.029ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(1000000)` | 0.906ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.143ms <span style="color:green">(2.1x)</span>&nbsp;🟢 | 0.148ms  <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *0.306ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Add(10000)` | 0.040ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.014ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.016ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.007ms  <span style="color:green">(2.2x)</span>&nbsp;🟢 | 0.007ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.014ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Add(100000)` | 0.400ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.140ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.155ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.166ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.061ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | 0.061ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | *0.144ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Add(1000000)` | 4.000ms <span style="color:red">(0.4x)</span>&nbsp;🟠 | 1.399ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.548ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.654ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.605ms  <span style="color:green">(2.4x)</span>&nbsp;🟢 | 0.608ms  <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.436ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `AddGrow(4, 1048576)`*³* | 4.647ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 1.886ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.759ms  <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.141ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.026ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | 1.033ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.402ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `AddGrow(65536, 1048576)`*³* | 4.604ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 1.865ms <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.773ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.122ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.083ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.010ms  <span style="color:green">(2.4x)</span>&nbsp;🟢 | *2.381ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Contains(1000)` | 0.371ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.086ms <span style="color:green">(4.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms  <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.370ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.148ms  <span style="color:green">(2.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms  <span style="color:green">(4.7x)</span>&nbsp;🟢 | *0.394ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(10000)` | 37.241ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.565ms <span style="color:green">(6.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.548ms  <span style="color:green">(6.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 37.203ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.541ms  <span style="color:green">(6.0x)</span>&nbsp;🟢 | 7.544ms  <span style="color:green">(6.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *45.509ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(10000)` | 0.037ms <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.009ms <span style="color:green">(2.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.005ms  <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.022ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.005ms  <span style="color:green">(5.0x)</span>&nbsp;🟢 | 0.005ms  <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.023ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IndexedRead(100000)` | 0.474ms <span style="color:red">(0.7x)</span>&nbsp;🟠 | 0.090ms <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.068ms  <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.268ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.077ms  <span style="color:green">(4.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.068ms  <span style="color:green">(4.8x)</span>&nbsp;🟢 | *0.328ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IndexedRead(1000000)` | 5.416ms <span style="color:red">(0.7x)</span>&nbsp;🟠 | 1.487ms <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.341ms  <span style="color:green">(2.9x)</span>&nbsp;🟢 | 3.197ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.395ms  <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.357ms  <span style="color:green">(2.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.897ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IndexedWrite(10000)` | 0.028ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.011ms <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.007ms  <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.006ms  <span style="color:green">(4.6x)</span>&nbsp;🟢 | 0.010ms  <span style="color:green">(3.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.029ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(100000)` | 0.311ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.125ms <span style="color:green">(2.7x)</span>&nbsp;🟢 | 0.135ms  <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.220ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.136ms  <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.132ms  <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.331ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(1000000)` | 3.656ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.892ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.868ms  <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.775ms <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.796ms  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.744ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | *3.956ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1000)` | 0.087ms <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.011ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.011ms  <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.085ms <span style="color:red">(0.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.011ms  <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.010ms  <span style="color:green">(2.2x)</span>&nbsp;🟢 | *0.022ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Remove(10000)` | 7.626ms <span style="color:red">(0.1x)</span>&nbsp;🟠 | 0.732ms <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.717ms  <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.616ms <span style="color:red">(0.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.716ms  <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.704ms  <span style="color:green">(1.2x)</span>&nbsp;🟢 | *0.853ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(10000)` | 0.038ms <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.004ms <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.003ms  <span style="color:green">(8.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.016ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.003ms  <span style="color:green">(9.0x)</span>&nbsp;🟢 | 0.003ms  <span style="color:green">(9.0x)</span>&nbsp;🟢 | *0.024ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(100000)` | 0.381ms <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.037ms <span style="color:green">(6.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.024ms <span style="color:green">(10.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.160ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.024ms <span style="color:green">(10.0x)</span>&nbsp;🟢 | 0.024ms <span style="color:green">(10.0x)</span>&nbsp;🟢 | *0.242ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(1000000)` | 3.815ms <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.360ms <span style="color:green">(6.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.229ms <span style="color:green">(10.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.621ms <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.226ms <span style="color:green">(10.7x)</span>&nbsp;🟢 | 0.226ms <span style="color:green">(10.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.419ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |

*¹* Optimizations were disabled to perform this benchmark<br/>
*³* AddGrow(capacity, growTo) -- Incrementally grows from `capacity` until reaching size of `growTo`<br/>

---
<br/>

### *ParallelHashMap*

| Functionality | NativeParallelHashMap (S) | NativeParallelHashMap (S+B) | NativeParallelHashMap (B) | UnsafeParallelHashMap (S) | UnsafeParallelHashMap (S+B) | UnsafeParallelHashMap (B) | *ConcurrentDictionary (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(1, 0)`*¹* | 0.462ms  <span style="color:green">(176.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.141ms  <span style="color:green">(577.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.109ms  <span style="color:green">(748.4x)</span>&nbsp;🟢 | 0.261ms  <span style="color:green">(312.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.162ms  <span style="color:green">(501.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.174ms  <span style="color:green">(469.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *81.423ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(2, 0)`*¹˒²* | 0.234ms  <span style="color:green">(551.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.072ms <span style="color:green">(1782.5x)</span>&nbsp;🟢 | 0.090ms <span style="color:green">(1427.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.134ms  <span style="color:green">(965.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.096ms <span style="color:green">(1338.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.091ms <span style="color:green">(1412.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *129.140ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(4, 0)`*¹˒²* | 0.267ms  <span style="color:green">(644.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.042ms <span style="color:green">(4088.3x)</span>&nbsp;🟢 | 0.050ms <span style="color:green">(3473.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.078ms <span style="color:green">(2214.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.048ms <span style="color:green">(3604.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.047ms <span style="color:green">(3626.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *171.914ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(1, 100)`*¹* | 0.682ms  <span style="color:green">(114.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.238ms  <span style="color:green">(326.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.242ms  <span style="color:green">(322.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.582ms  <span style="color:green">(133.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.181ms  <span style="color:green">(429.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.181ms  <span style="color:green">(429.9x)</span>&nbsp;🟢 | *77.786ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(2, 100)`*¹˒²* | 0.380ms  <span style="color:green">(341.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.124ms <span style="color:green">(1046.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.142ms  <span style="color:green">(911.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.295ms  <span style="color:green">(440.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.093ms <span style="color:green">(1399.5x)</span>&nbsp;🟢 | 0.095ms <span style="color:green">(1370.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *129.804ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(4, 100)`*¹˒²* | 0.354ms  <span style="color:green">(490.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.114ms <span style="color:green">(1518.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.125ms <span style="color:green">(1385.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.217ms  <span style="color:green">(799.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.109ms <span style="color:green">(1596.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.062ms <span style="color:green">(2818.0x)</span>&nbsp;🟢 | *173.587ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(1, 0)`*¹* | 0.535ms  <span style="color:green">(150.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.201ms  <span style="color:green">(401.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.155ms  <span style="color:green">(521.9x)</span>&nbsp;🟢 | 0.287ms  <span style="color:green">(280.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.181ms  <span style="color:green">(445.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms  <span style="color:green">(501.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *80.634ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(2, 0)`*¹˒²* | 0.271ms  <span style="color:green">(455.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.103ms <span style="color:green">(1195.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.080ms <span style="color:green">(1532.7x)</span>&nbsp;🟢 | 0.148ms  <span style="color:green">(831.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.093ms <span style="color:green">(1326.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.083ms <span style="color:green">(1491.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *123.229ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(4, 0)`*¹˒²* | 0.144ms <span style="color:green">(1320.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.061ms <span style="color:green">(3106.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.046ms <span style="color:green">(4132.8x)</span>&nbsp;🟢 | 0.083ms <span style="color:green">(2294.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.103ms <span style="color:green">(1846.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.051ms <span style="color:green">(3730.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *189.491ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(1, 100)`*¹* | 3.685ms   <span style="color:green">(25.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.444ms   <span style="color:green">(65.7x)</span>&nbsp;🟢 | 1.693ms   <span style="color:green">(56.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.191ms   <span style="color:green">(29.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.544ms   <span style="color:green">(61.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.614ms   <span style="color:green">(58.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *94.884ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(2, 100)`*¹˒²* | 1.845ms   <span style="color:green">(73.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.736ms  <span style="color:green">(185.3x)</span>&nbsp;🟢 | 0.887ms  <span style="color:green">(153.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.595ms   <span style="color:green">(85.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.773ms  <span style="color:green">(176.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.825ms  <span style="color:green">(165.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *136.423ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(4, 100)`*¹˒²* | 1.613ms  <span style="color:green">(113.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.708ms  <span style="color:green">(259.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.707ms  <span style="color:green">(259.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.460ms  <span style="color:green">(125.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.746ms  <span style="color:green">(246.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.689ms  <span style="color:green">(266.5x)</span>&nbsp;🟢 | *183.655ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArrayKeys(1, 10000)` | 0.150ms    <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.121ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.081ms    <span style="color:green">(2.2x)</span>&nbsp;🟢 | 0.201ms    <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.129ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.180ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArrayKeys(1, 100000)` | 1.652ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.243ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.052ms    <span style="color:green">(2.2x)</span>&nbsp;🟢 | 1.796ms    <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.402ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.053ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.336ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArrayKeys(1, 1000000)` | 36.653ms    <span style="color:red">(0.7x)</span>&nbsp;🟠 | 17.665ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.848ms    <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.236ms    <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.985ms    <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.798ms    <span style="color:green">(2.3x)</span>&nbsp;🟢 | *25.361ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArrayValues(1, 10000)` | 0.150ms    <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.121ms    <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.080ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.151ms    <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.122ms    <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.079ms    <span style="color:green">(1.8x)</span>&nbsp;🟢 | *0.141ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArrayValues(1, 100000)` | 1.626ms    <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.235ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.862ms    <span style="color:green">(2.1x)</span>&nbsp;🟢 | 1.629ms    <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.229ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.872ms    <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.773ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArrayValues(1, 1000000)` | 20.867ms    <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.371ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.046ms    <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 24.782ms    <span style="color:grey">(1.0x)</span>&nbsp;🟠 | 17.345ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.785ms    <span style="color:green">(2.2x)</span>&nbsp;🟢 | *23.593ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Insert(1, 10000)` | 0.353ms    <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.209ms    <span style="color:green">(9.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.212ms    <span style="color:green">(9.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.320ms    <span style="color:green">(6.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.205ms    <span style="color:green">(9.6x)</span>&nbsp;🟢 | 0.211ms    <span style="color:green">(9.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.979ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 10000)`*²* | 0.543ms    <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.514ms    <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.329ms    <span style="color:green">(7.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.400ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.266ms    <span style="color:green">(8.8x)</span>&nbsp;🟢 | 0.379ms    <span style="color:green">(6.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.330ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 10000)`*²* | 0.449ms    <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.290ms    <span style="color:green">(8.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.217ms   <span style="color:green">(10.6x)</span>&nbsp;🟢 | 0.285ms    <span style="color:green">(8.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.249ms    <span style="color:green">(9.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.270ms    <span style="color:green">(8.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.314ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1, 100000)` | 3.818ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.325ms    <span style="color:green">(9.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.281ms    <span style="color:green">(9.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.442ms    <span style="color:green">(6.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.218ms    <span style="color:green">(9.9x)</span>&nbsp;🟢 | 2.285ms    <span style="color:green">(9.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *21.983ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 100000)`*²* | 5.611ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.873ms    <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.254ms    <span style="color:green">(7.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.090ms    <span style="color:green">(5.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.645ms    <span style="color:green">(8.8x)</span>&nbsp;🟢 | 3.080ms    <span style="color:green">(7.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *23.181ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 100000)`*²* | 4.523ms    <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.897ms    <span style="color:green">(8.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.156ms   <span style="color:green">(11.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.541ms    <span style="color:green">(6.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.201ms   <span style="color:green">(11.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.096ms   <span style="color:green">(11.5x)</span>&nbsp;🟢 | *24.121ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1, 1000000)` | 60.383ms    <span style="color:green">(7.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.007ms   <span style="color:green">(11.8x)</span>&nbsp;🟢 | 36.109ms   <span style="color:green">(11.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 53.923ms    <span style="color:green">(7.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.016ms   <span style="color:green">(11.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.542ms   <span style="color:green">(11.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *425.024ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 1000000)`*²* | 62.895ms    <span style="color:green">(7.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 50.118ms    <span style="color:green">(8.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 40.151ms   <span style="color:green">(11.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 50.271ms    <span style="color:green">(8.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.964ms   <span style="color:green">(11.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 38.384ms   <span style="color:green">(11.6x)</span>&nbsp;🟢 | *443.920ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 1000000)`*²* | 42.694ms    <span style="color:green">(7.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.240ms    <span style="color:green">(9.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 24.896ms   <span style="color:green">(13.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 30.771ms   <span style="color:green">(10.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 24.408ms   <span style="color:green">(13.3x)</span>&nbsp;🟢 | 25.097ms   <span style="color:green">(13.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *325.595ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `AddGrow(1, 4, 1048576)`*³* | 72.547ms    <span style="color:green">(5.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.816ms   <span style="color:green">(10.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.313ms   <span style="color:green">(10.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 71.458ms    <span style="color:green">(6.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.813ms   <span style="color:green">(10.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.265ms   <span style="color:green">(10.8x)</span>&nbsp;🟢 | *425.495ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `AddGrow(1, 65536, 1048576)`*³* | 68.046ms   <span style="color:green">(10.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 39.004ms   <span style="color:green">(17.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 38.764ms   <span style="color:green">(17.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 67.198ms   <span style="color:green">(10.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 38.417ms   <span style="color:green">(17.8x)</span>&nbsp;🟢 | 38.540ms   <span style="color:green">(17.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *683.780ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 10000)` | 0.145ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.033ms    <span style="color:green">(6.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.028ms    <span style="color:green">(8.0x)</span>&nbsp;🟢 | 0.118ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms    <span style="color:green">(6.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.029ms    <span style="color:green">(7.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.228ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 10000)`*²* | 0.127ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.042ms    <span style="color:green">(4.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms    <span style="color:green">(5.4x)</span>&nbsp;🟢 | 0.111ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.038ms    <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms    <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.194ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 10000)`*²* | 0.167ms    <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.052ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.055ms    <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.100ms    <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.068ms    <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.039ms    <span style="color:green">(5.5x)</span>&nbsp;🟢 | *0.213ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 100000)` | 2.247ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.650ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.498ms    <span style="color:green">(6.6x)</span>&nbsp;🟢 | 1.849ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.650ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.500ms    <span style="color:green">(6.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.277ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 100000)`*²* | 1.226ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.403ms    <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.328ms    <span style="color:green">(5.4x)</span>&nbsp;🟢 | 1.077ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.408ms    <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.330ms    <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.761ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 100000)`*²* | 1.065ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.334ms    <span style="color:green">(7.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.268ms    <span style="color:green">(8.7x)</span>&nbsp;🟢 | 0.883ms    <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.319ms    <span style="color:green">(7.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.540ms    <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.332ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 1000000)` | 66.122ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.585ms    <span style="color:green">(5.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.089ms    <span style="color:green">(8.0x)</span>&nbsp;🟢 | 59.523ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.021ms    <span style="color:green">(5.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.118ms    <span style="color:green">(8.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *97.095ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 1000000)`*²* | 31.624ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 8.707ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.498ms    <span style="color:green">(7.8x)</span>&nbsp;🟢 | 29.568ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 8.714ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.511ms    <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *50.806ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 1000000)`*²* | 25.406ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.925ms    <span style="color:green">(6.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 5.677ms    <span style="color:green">(7.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 22.636ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 6.716ms    <span style="color:green">(6.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 5.494ms    <span style="color:green">(7.9x)</span>&nbsp;🟢 | *43.614ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(1, 10000)` | 0.145ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.029ms    <span style="color:green">(8.1x)</span>&nbsp;🟢 | 0.032ms    <span style="color:green">(7.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.137ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.031ms    <span style="color:green">(7.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.031ms    <span style="color:green">(7.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.235ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(2, 10000)`*²* | 0.202ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.059ms    <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.062ms    <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.191ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.041ms    <span style="color:green">(7.0x)</span>&nbsp;🟢 | 0.066ms    <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.288ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(4, 10000)`*²* | 0.581ms    <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.129ms    <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.098ms    <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.264ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.071ms    <span style="color:green">(7.1x)</span>&nbsp;🟢 | 0.097ms    <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.501ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IndexedRead(1, 100000)` | 2.216ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.592ms    <span style="color:green">(5.6x)</span>&nbsp;🟢 | 0.604ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.140ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.600ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.607ms    <span style="color:green">(5.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.291ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(2, 100000)`*²* | 2.416ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.698ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.692ms    <span style="color:green">(5.1x)</span>&nbsp;🟢 | 2.270ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.707ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.743ms    <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.506ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(4, 100000)`*²* | 4.094ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.071ms    <span style="color:green">(5.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.053ms    <span style="color:green">(5.5x)</span>&nbsp;🟢 | 7.214ms    <span style="color:red">(0.8x)</span>&nbsp;🟠 | 1.058ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.794ms    <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *5.780ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IndexedRead(1, 1000000)` | 64.603ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.636ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.726ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 62.234ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.652ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.411ms    <span style="color:green">(5.6x)</span>&nbsp;🟢 | *96.983ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(2, 1000000)`*²* | 63.460ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.217ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.124ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 61.578ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.127ms    <span style="color:green">(5.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.957ms    <span style="color:green">(5.8x)</span>&nbsp;🟢 | *99.146ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedRead(4, 1000000)`*²* | 68.243ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 28.318ms    <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 27.812ms    <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 69.192ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 26.990ms    <span style="color:green">(3.6x)</span>&nbsp;🟢 | 27.918ms    <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *97.383ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(1, 10000)` | 0.164ms    <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.051ms    <span style="color:green">(9.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.041ms   <span style="color:green">(11.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.131ms    <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.040ms   <span style="color:green">(11.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.038ms   <span style="color:green">(12.0x)</span>&nbsp;🟢 | *0.456ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(1, 100000)` | 2.333ms    <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.901ms    <span style="color:green">(6.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.731ms    <span style="color:green">(8.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.077ms    <span style="color:green">(2.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.781ms    <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.710ms    <span style="color:green">(8.5x)</span>&nbsp;🟢 | *6.067ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IndexedWrite(1, 1000000)` | 76.627ms    <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 67.296ms    <span style="color:green">(2.8x)</span>&nbsp;🟢 | 68.052ms    <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 85.977ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 68.516ms    <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 69.221ms    <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *191.108ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(1, 10000)` | 0.154ms    <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.043ms    <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.032ms    <span style="color:green">(6.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.117ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.043ms    <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.031ms    <span style="color:green">(6.6x)</span>&nbsp;🟢 | *0.206ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(2, 10000)`*²* | 0.125ms    <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.045ms    <span style="color:green">(3.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms    <span style="color:green">(4.8x)</span>&nbsp;🟢 | 0.110ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.046ms    <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.036ms    <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.172ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(4, 10000)`*²* | 0.170ms    <span style="color:red">(0.7x)</span>&nbsp;🟠 | 0.051ms    <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.038ms    <span style="color:green">(3.3x)</span>&nbsp;🟢 | 0.103ms    <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.078ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.039ms    <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.125ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `TryGetValue(1, 100000)` | 2.187ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.839ms    <span style="color:green">(4.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.616ms    <span style="color:green">(5.4x)</span>&nbsp;🟢 | 1.925ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.815ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.628ms    <span style="color:green">(5.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.336ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(2, 100000)`*²* | 1.216ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.478ms    <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.342ms    <span style="color:green">(5.2x)</span>&nbsp;🟢 | 1.072ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.489ms    <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.391ms    <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.769ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(4, 100000)`*²* | 1.042ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.408ms    <span style="color:green">(4.3x)</span>&nbsp;🟢 | 0.617ms    <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.899ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.915ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.636ms    <span style="color:green">(2.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.736ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(1, 1000000)` | 65.145ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 25.321ms    <span style="color:green">(3.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.163ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 59.895ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 23.602ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.464ms    <span style="color:green">(5.2x)</span>&nbsp;🟢 | *96.395ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(2, 1000000)`*²* | 31.724ms    <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.422ms    <span style="color:green">(4.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 9.631ms    <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 30.638ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.432ms    <span style="color:green">(4.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 9.589ms    <span style="color:green">(5.1x)</span>&nbsp;🟢 | *49.107ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `TryGetValue(4, 1000000)`*²* | 25.831ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.070ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.992ms    <span style="color:green">(5.2x)</span>&nbsp;🟢 | 23.710ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.235ms    <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 8.062ms    <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *41.691ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 10000)` | 0.120ms    <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.214ms    <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.050ms   <span style="color:green">(11.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.095ms    <span style="color:green">(5.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.050ms   <span style="color:green">(10.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.049ms   <span style="color:green">(11.1x)</span>&nbsp;🟢 | *0.545ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 100000)` | 1.928ms    <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.929ms    <span style="color:green">(7.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.805ms    <span style="color:green">(8.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.682ms    <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.867ms    <span style="color:green">(7.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.793ms    <span style="color:green">(8.2x)</span>&nbsp;🟢 | *6.512ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 1000000)` | 64.353ms    <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 56.893ms    <span style="color:green">(3.5x)</span>&nbsp;🟢 | 57.422ms    <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 62.480ms    <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 57.884ms    <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 57.271ms    <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *196.582ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(1, 10000)` | 0.156ms    <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.086ms    <span style="color:green">(4.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.073ms    <span style="color:green">(5.4x)</span>&nbsp;🟢 | 0.143ms    <span style="color:green">(2.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.080ms    <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.080ms    <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.393ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(1, 100000)` | 2.094ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.931ms    <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.839ms    <span style="color:green">(5.8x)</span>&nbsp;🟢 | 1.862ms    <span style="color:green">(2.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.885ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.884ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *4.876ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(1, 1000000)` | 28.544ms    <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.060ms    <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.143ms    <span style="color:green">(5.6x)</span>&nbsp;🟢 | 27.167ms    <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.318ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.364ms    <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *56.852ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*¹* Optimizations were disabled to perform this benchmark<br/>
*²* Benchmark run on parallel job workers - results may vary<br/>
*³* AddGrow(workers, capacity, growTo) -- Incrementally grows from `capacity` until reaching size of `growTo`<br/>

---
<br/>

### *ParallelHashSet*

| Functionality | NativeParallelHashSet (S) | NativeParallelHashSet (S+B) | NativeParallelHashSet (B) | UnsafeParallelHashSet (S) | UnsafeParallelHashSet (S+B) | UnsafeParallelHashSet (B) | *HashSet w/lock (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(1, 0)`*¹* | 0.482ms   <span style="color:green">(9.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.115ms  <span style="color:green">(38.5x)</span>&nbsp;🟢 | 0.176ms  <span style="color:green">(25.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.301ms  <span style="color:green">(14.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.183ms  <span style="color:green">(24.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.171ms  <span style="color:green">(25.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *4.422ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(2, 0)`*¹˒²* | 0.244ms  <span style="color:green">(61.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.060ms <span style="color:green">(250.7x)</span>&nbsp;🟢 | 0.092ms <span style="color:green">(164.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.154ms  <span style="color:green">(98.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.091ms <span style="color:green">(166.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.086ms <span style="color:green">(175.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *15.041ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(4, 0)`*¹˒²* | 0.274ms <span style="color:green">(114.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.037ms <span style="color:green">(849.5x)</span>&nbsp;🟢 | 0.048ms <span style="color:green">(659.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.153ms <span style="color:green">(206.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.049ms <span style="color:green">(640.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.047ms <span style="color:green">(667.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *31.474ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(1, 100)`*¹* | 0.567ms   <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.128ms  <span style="color:green">(34.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.201ms  <span style="color:green">(22.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.401ms  <span style="color:green">(11.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.142ms  <span style="color:green">(31.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms  <span style="color:green">(40.9x)</span>&nbsp;🟢 | *4.424ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(2, 100)`*¹˒²* | 0.288ms  <span style="color:green">(52.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.068ms <span style="color:green">(221.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.105ms <span style="color:green">(143.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.217ms  <span style="color:green">(69.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.074ms <span style="color:green">(205.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.057ms <span style="color:green">(264.5x)</span>&nbsp;🟢 | *15.128ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IsEmpty_x_100k(4, 100)`*¹˒²* | 0.315ms  <span style="color:green">(99.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.072ms <span style="color:green">(437.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.058ms <span style="color:green">(538.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.185ms <span style="color:green">(169.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.046ms <span style="color:green">(686.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.037ms <span style="color:green">(842.3x)</span>&nbsp;🟢 | *31.420ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(1, 0)`*¹* | 0.535ms   <span style="color:green">(8.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.201ms  <span style="color:green">(22.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms  <span style="color:green">(27.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.456ms   <span style="color:green">(9.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.181ms  <span style="color:green">(24.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms  <span style="color:green">(27.6x)</span>&nbsp;🟢 | *4.435ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(2, 0)`*¹˒²* | 0.271ms  <span style="color:green">(59.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.103ms <span style="color:green">(155.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.082ms <span style="color:green">(193.8x)</span>&nbsp;🟢 | 0.231ms  <span style="color:green">(69.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.093ms <span style="color:green">(171.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.083ms <span style="color:green">(192.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *15.965ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(4, 0)`*¹˒²* | 0.224ms <span style="color:green">(173.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.115ms <span style="color:green">(337.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.049ms <span style="color:green">(789.8x)</span>&nbsp;🟢 | 0.164ms <span style="color:green">(237.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.054ms <span style="color:green">(724.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.073ms <span style="color:green">(529.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *38.861ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(1, 100)`*¹* | 4.426ms   <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.620ms   <span style="color:green">(2.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.517ms   <span style="color:green">(2.9x)</span>&nbsp;🟢 | 3.323ms   <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.538ms   <span style="color:green">(2.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.268ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *4.438ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(2, 100)`*¹˒²* | 2.462ms   <span style="color:green">(6.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.020ms  <span style="color:green">(14.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.763ms  <span style="color:green">(19.9x)</span>&nbsp;🟢 | 1.683ms   <span style="color:green">(9.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.783ms  <span style="color:green">(19.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.824ms  <span style="color:green">(18.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *15.206ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Count_x_100k(4, 100)`*¹˒²* | 1.778ms  <span style="color:green">(18.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.848ms  <span style="color:green">(37.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.723ms  <span style="color:green">(44.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.556ms  <span style="color:green">(20.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.744ms  <span style="color:green">(43.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.665ms  <span style="color:green">(48.4x)</span>&nbsp;🟢 | *32.165ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArray(1, 10000)` | 0.039ms   <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.021ms   <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.038ms   <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.021ms   <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms   <span style="color:green">(1.9x)</span>&nbsp;🟢 | *0.018ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(1, 100000)` | 0.428ms   <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.202ms   <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms   <span style="color:green">(2.1x)</span>&nbsp;🟢 | 0.437ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.202ms   <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.084ms   <span style="color:green">(2.1x)</span>&nbsp;🟢 | *0.175ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(1, 1000000)` | 4.489ms   <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.192ms   <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.051ms   <span style="color:green">(1.9x)</span>&nbsp;🟢 | 4.690ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 2.187ms   <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.053ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.964ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Insert(1, 10000)` | 0.330ms  <span style="color:green">(11.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.188ms  <span style="color:green">(19.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.196ms  <span style="color:green">(19.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.301ms  <span style="color:green">(12.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.186ms  <span style="color:green">(20.0x)</span>&nbsp;🟢 | 0.202ms  <span style="color:green">(18.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.715ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 10000)`*²* | 0.468ms  <span style="color:green">(33.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.487ms  <span style="color:green">(31.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.264ms  <span style="color:green">(58.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.317ms  <span style="color:green">(49.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.260ms  <span style="color:green">(59.8x)</span>&nbsp;🟢 | 0.331ms  <span style="color:green">(47.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *15.537ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 10000)`*²* | 0.285ms <span style="color:green">(168.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.319ms <span style="color:green">(150.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.169ms <span style="color:green">(283.9x)</span>&nbsp;🟢 | 0.244ms <span style="color:green">(196.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.207ms <span style="color:green">(231.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.225ms <span style="color:green">(212.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *48.000ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1, 100000)` | 3.300ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.880ms   <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.957ms   <span style="color:green">(3.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.014ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.857ms   <span style="color:green">(3.2x)</span>&nbsp;🟢 | 2.079ms   <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *5.872ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 100000)`*²* | 4.849ms   <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.541ms   <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.555ms   <span style="color:green">(6.1x)</span>&nbsp;🟢 | 3.014ms   <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.288ms   <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.275ms   <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *15.510ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 100000)`*²* | 2.759ms  <span style="color:green">(16.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.462ms  <span style="color:green">(19.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.494ms  <span style="color:green">(31.3x)</span>&nbsp;🟢 | 2.236ms  <span style="color:green">(20.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.221ms  <span style="color:green">(21.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.804ms  <span style="color:green">(25.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *46.684ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(1, 1000000)` | 33.989ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.882ms   <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 20.803ms   <span style="color:green">(3.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 31.233ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 19.637ms   <span style="color:green">(3.1x)</span>&nbsp;🟢 | 20.789ms   <span style="color:green">(3.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *61.451ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(2, 1000000)`*²* | 48.854ms   <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 46.969ms   <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 27.594ms   <span style="color:green">(2.5x)</span>&nbsp;🟢 | 31.891ms   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 33.639ms   <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 35.067ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *70.068ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Insert(4, 1000000)`*²* | 32.946ms   <span style="color:green">(2.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 28.736ms   <span style="color:green">(3.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.753ms   <span style="color:green">(4.9x)</span>&nbsp;🟢 | 21.186ms   <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 24.702ms   <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 21.382ms   <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *91.349ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `AddGrow(1, 4, 1048576)`*³* | 36.009ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.228ms   <span style="color:green">(5.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.699ms   <span style="color:green">(5.6x)</span>&nbsp;🟢 | 34.592ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.898ms   <span style="color:green">(5.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.875ms   <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *65.912ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `AddGrow(1, 65536, 1048576)`*³* | 33.973ms   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.863ms   <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.247ms   <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 32.550ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.464ms   <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.203ms   <span style="color:green">(5.2x)</span>&nbsp;🟢 | *58.064ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 10000)` | 0.109ms   <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.019ms  <span style="color:green">(32.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.013ms  <span style="color:green">(47.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.095ms   <span style="color:green">(6.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms  <span style="color:green">(35.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.010ms  <span style="color:green">(60.2x)</span>&nbsp;🟢 | *0.611ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 10000)`*²* | 0.101ms <span style="color:green">(141.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.019ms <span style="color:green">(749.5x)</span>&nbsp;🟢 | 0.021ms <span style="color:green">(683.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.060ms <span style="color:green">(239.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.019ms <span style="color:green">(747.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.021ms <span style="color:green">(683.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *14.279ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 10000)`*²* | 0.098ms <span style="color:green">(128.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.031ms <span style="color:green">(402.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.023ms <span style="color:green">(559.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.057ms <span style="color:green">(219.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.021ms <span style="color:green">(607.8x)</span>&nbsp;🟢 | 0.022ms <span style="color:green">(561.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *12.582ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 100000)` | 1.531ms   <span style="color:green">(4.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.284ms  <span style="color:green">(24.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.191ms  <span style="color:green">(36.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.345ms   <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.300ms  <span style="color:green">(23.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.191ms  <span style="color:green">(36.9x)</span>&nbsp;🟢 | *7.043ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 100000)`*²* | 0.925ms  <span style="color:green">(23.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.225ms  <span style="color:green">(95.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.165ms <span style="color:green">(130.4x)</span>&nbsp;🟢 | 0.827ms  <span style="color:green">(26.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.227ms  <span style="color:green">(94.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.166ms <span style="color:green">(129.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *21.506ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 100000)`*²* | 0.717ms  <span style="color:green">(46.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.204ms <span style="color:green">(164.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.120ms <span style="color:green">(279.4x)</span>&nbsp;🟢 | 0.689ms  <span style="color:green">(48.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.389ms  <span style="color:green">(86.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.275ms <span style="color:green">(122.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *33.617ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(1, 1000000)` | 18.170ms   <span style="color:green">(4.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.754ms  <span style="color:green">(21.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.522ms  <span style="color:green">(32.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.496ms   <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.749ms  <span style="color:green">(21.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.491ms  <span style="color:green">(32.8x)</span>&nbsp;🟢 | *81.628ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(2, 1000000)`*²* | 11.131ms   <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.652ms  <span style="color:green">(32.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.045ms  <span style="color:green">(42.5x)</span>&nbsp;🟢 | 9.589ms   <span style="color:green">(9.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.733ms  <span style="color:green">(31.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.076ms  <span style="color:green">(41.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *86.828ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Contains(4, 1000000)`*²* | 8.584ms  <span style="color:green">(12.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.407ms  <span style="color:green">(32.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.220ms  <span style="color:green">(49.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 8.219ms  <span style="color:green">(13.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.053ms  <span style="color:green">(53.5x)</span>&nbsp;🟢 | 2.324ms  <span style="color:green">(47.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *109.936ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 10000)` | 0.139ms   <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.065ms   <span style="color:green">(9.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.059ms  <span style="color:green">(10.3x)</span>&nbsp;🟢 | 0.110ms   <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.061ms  <span style="color:green">(10.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.060ms  <span style="color:green">(10.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.611ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 100000)` | 1.694ms   <span style="color:green">(3.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.798ms   <span style="color:green">(8.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.689ms   <span style="color:green">(9.7x)</span>&nbsp;🟢 | 1.314ms   <span style="color:green">(5.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.707ms   <span style="color:green">(9.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.695ms   <span style="color:green">(9.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *6.684ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Remove(1, 1000000)` | 20.302ms   <span style="color:green">(3.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 9.389ms   <span style="color:green">(8.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.772ms   <span style="color:green">(9.7x)</span>&nbsp;🟢 | 15.004ms   <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 8.087ms   <span style="color:green">(9.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 7.788ms   <span style="color:green">(9.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *75.082ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(1, 10000)` | 0.097ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.024ms   <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.068ms   <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms   <span style="color:green">(2.0x)</span>&nbsp;🟢 | 0.018ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.035ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(1, 100000)` | 0.929ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.208ms   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.145ms   <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.605ms   <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.144ms   <span style="color:green">(2.4x)</span>&nbsp;🟢 | 0.144ms   <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.344ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(1, 1000000)` | 9.214ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 2.094ms   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.470ms   <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 5.994ms   <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.462ms   <span style="color:green">(2.5x)</span>&nbsp;🟢 | 1.491ms   <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.611ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `UnionWith(1, 10000)` | 0.539ms   <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.227ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.216ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.490ms   <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.214ms   <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.214ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.242ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `UnionWith(1, 100000)` | 5.532ms   <span style="color:red">(0.5x)</span>&nbsp;🟠 | 2.397ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.465ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.955ms   <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.263ms   <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.242ms   <span style="color:green">(1.2x)</span>&nbsp;🟢 | *2.687ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `UnionWith(1, 1000000)` | 79.156ms   <span style="color:red">(0.6x)</span>&nbsp;🟠 | 41.627ms   <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.230ms   <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 72.721ms   <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 36.150ms   <span style="color:green">(1.4x)</span>&nbsp;🟢 | 36.708ms   <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *48.928ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IntersectWith(1, 10000)` | 0.318ms   <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.135ms   <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.118ms   <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.264ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.110ms   <span style="color:green">(2.6x)</span>&nbsp;🟢 | 0.112ms   <span style="color:green">(2.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.286ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IntersectWith(1, 100000)` | 3.460ms   <span style="color:red">(0.9x)</span>&nbsp;🟠 | 1.490ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.322ms   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.881ms   <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.259ms   <span style="color:green">(2.4x)</span>&nbsp;🟢 | 1.280ms   <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2.963ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IntersectWith(1, 1000000)` | 50.949ms   <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.330ms   <span style="color:green">(3.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 16.081ms   <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 41.292ms   <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.816ms   <span style="color:green">(4.1x)</span>&nbsp;🟢 | 15.828ms   <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *65.453ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ExceptWith(1, 10000)` | 0.269ms   <span style="color:red">(0.9x)</span>&nbsp;🟠 | 0.213ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.118ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.197ms   <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.115ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.112ms   <span style="color:green">(2.1x)</span>&nbsp;🟢 | *0.230ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ExceptWith(1, 100000)` | 2.960ms   <span style="color:red">(0.8x)</span>&nbsp;🟠 | 1.408ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.335ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.181ms   <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.320ms   <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.280ms   <span style="color:green">(1.9x)</span>&nbsp;🟢 | *2.467ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ExceptWith(1, 1000000)` | 40.054ms   <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 20.188ms   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.223ms   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 30.004ms   <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 18.972ms   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.592ms   <span style="color:green">(2.3x)</span>&nbsp;🟢 | *40.898ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*¹* Optimizations were disabled to perform this benchmark<br/>
*²* Benchmark run on parallel job workers - results may vary<br/>
*³* AddGrow(workers, capacity, growTo) -- Incrementally grows from `capacity` until reaching size of `growTo`<br/>

---
<br/>

### *QueueParallelWriter*

| Functionality | NativeQueueParallelWriter (S) | NativeQueueParallelWriter (S+B) | NativeQueueParallelWriter (B) | UnsafeQueueParallelWriter (S) | UnsafeQueueParallelWriter (S+B) | UnsafeQueueParallelWriter (B) | *ConcurrentQueue (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `EnqueueGrow(1, 10000)`*³* | 0.063ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.037ms   <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.027ms   <span style="color:green">(4.2x)</span>&nbsp;🟢 | --- | --- | --- | *0.112ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(2, 10000)`*²˒³* | 0.036ms   <span style="color:green">(3.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.032ms   <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.022ms   <span style="color:green">(6.3x)</span>&nbsp;🟢 | --- | --- | --- | *0.136ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(4, 10000)`*²˒³* | 0.041ms   <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.023ms   <span style="color:green">(9.1x)</span>&nbsp;🟢 | 0.028ms   <span style="color:green">(7.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *0.205ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(1, 100000)`*³* | 1.111ms   <span style="color:grey">(1.0x)</span>&nbsp;🟠 | 0.196ms   <span style="color:green">(5.5x)</span>&nbsp;🟢 | 0.249ms   <span style="color:green">(4.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *1.069ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `EnqueueGrow(2, 100000)`*²˒³* | 0.353ms  <span style="color:green">(43.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.129ms <span style="color:green">(118.3x)</span>&nbsp;🟢 | 0.141ms <span style="color:green">(107.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *15.233ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(4, 100000)`*²˒³* | 0.359ms <span style="color:green">(128.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.119ms <span style="color:green">(384.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.101ms <span style="color:green">(455.1x)</span>&nbsp;🟢 | --- | --- | --- | *45.962ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(1, 1000000)`*³* | 6.964ms   <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.971ms   <span style="color:green">(5.3x)</span>&nbsp;🟢 | 2.470ms   <span style="color:green">(4.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *10.493ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(2, 1000000)`*²˒³* | 3.587ms   <span style="color:green">(4.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.264ms  <span style="color:green">(12.0x)</span>&nbsp;🟢 | 1.353ms  <span style="color:green">(11.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *15.213ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(4, 1000000)`*²˒³* | 3.119ms  <span style="color:green">(14.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.036ms  <span style="color:green">(44.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.915ms  <span style="color:green">(50.7x)</span>&nbsp;🟢 | --- | --- | --- | *46.400ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(1, 10000)`*⁴* | 0.063ms   <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.014ms   <span style="color:green">(8.0x)</span>&nbsp;🟢 | 0.019ms   <span style="color:green">(5.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *0.112ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(2, 10000)`*²˒⁴* | 0.043ms   <span style="color:green">(3.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.015ms   <span style="color:green">(8.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.013ms  <span style="color:green">(10.1x)</span>&nbsp;🟢 | --- | --- | --- | *0.132ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(4, 10000)`*²˒⁴* | 0.036ms   <span style="color:green">(5.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms  <span style="color:green">(11.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.016ms  <span style="color:green">(13.0x)</span>&nbsp;🟢 | --- | --- | --- | *0.203ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(1, 100000)`*⁴* | 0.628ms   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.244ms   <span style="color:green">(4.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.187ms   <span style="color:green">(5.7x)</span>&nbsp;🟢 | --- | --- | --- | *1.068ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(2, 100000)`*²˒⁴* | 0.329ms  <span style="color:green">(46.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.142ms <span style="color:green">(107.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.107ms <span style="color:green">(142.5x)</span>&nbsp;🟢 | --- | --- | --- | *15.253ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(4, 100000)`*²˒⁴* | 0.305ms <span style="color:green">(154.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.077ms <span style="color:green">(611.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.061ms <span style="color:green">(767.5x)</span>&nbsp;🟢 | --- | --- | --- | *47.086ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(1, 1000000)`*⁴* | 6.283ms   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.374ms   <span style="color:green">(7.6x)</span>&nbsp;🟢 | 1.869ms   <span style="color:green">(5.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *10.486ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(2, 1000000)`*²˒⁴* | 3.268ms   <span style="color:green">(4.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.896ms  <span style="color:green">(17.0x)</span>&nbsp;🟢 | 1.029ms  <span style="color:green">(14.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *15.201ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(4, 1000000)`*²˒⁴* | 2.931ms  <span style="color:green">(15.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.638ms  <span style="color:green">(72.4x)</span>&nbsp;🟢 | 0.697ms  <span style="color:green">(66.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | --- | --- | --- | *46.225ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*²* Benchmark run on parallel job workers - results may vary<br/>
*³* EnqueueGrow(workers, insertions)<br/>
*⁴* Enqueue(workers, insertions)<br/>

---
<br/>

### *Queue*

| Functionality | NativeQueue (S) | NativeQueue (S+B) | NativeQueue (B) | UnsafeQueue (S) | UnsafeQueue (S+B) | UnsafeQueue (B) | *Queue (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(0)`*¹* | 0.482ms  <span style="color:red">(0.2x)</span>&nbsp;🟠 | 0.181ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.232ms  <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.000ms  <span style="color:green">(334.3x)</span>&nbsp;🟢 | 0.000ms  <span style="color:green">(334.3x)</span>&nbsp;🟢 | *0.100ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IsEmpty_x_100k(100)`*¹* | 0.503ms  <span style="color:red">(0.2x)</span>&nbsp;🟠 | 0.188ms  <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.141ms  <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.241ms  <span style="color:red">(0.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.000ms  <span style="color:green">(334.3x)</span>&nbsp;🟢 | 0.000ms  <span style="color:green">(334.3x)</span>&nbsp;🟢 | *0.100ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(0)`*¹* | 0.313ms  <span style="color:red">(0.4x)</span>&nbsp;🟠 | 0.193ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.161ms  <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.189ms  <span style="color:red">(0.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.000ms  <span style="color:green">(401.2x)</span>&nbsp;🟢 | 0.000ms  <span style="color:green">(401.2x)</span>&nbsp;🟢 | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(100)`*¹* | 0.351ms  <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.181ms  <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.141ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.231ms  <span style="color:red">(0.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.000ms  <span style="color:green">(401.2x)</span>&nbsp;🟢 | 0.000ms  <span style="color:green">(343.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(10000)` | 0.003ms  <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms  <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms  <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms  <span style="color:green">(1.8x)</span>&nbsp;🟢 | 0.002ms    <span style="color:green">(1.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.002ms    <span style="color:green">(1.8x)</span>&nbsp;🟢 | *0.003ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `ToNativeArray(100000)` | 0.096ms  <span style="color:red">(0.3x)</span>&nbsp;🟠 | 0.016ms  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.015ms  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.089ms  <span style="color:red">(0.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.015ms    <span style="color:green">(1.9x)</span>&nbsp;🟢 | 0.015ms    <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.029ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `ToNativeArray(1000000)` | 0.991ms  <span style="color:red">(0.8x)</span>&nbsp;🟠 | 0.197ms  <span style="color:green">(4.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.163ms  <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.897ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.156ms    <span style="color:green">(5.2x)</span>&nbsp;🟢 | 0.161ms    <span style="color:green">(5.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.814ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `EnqueueGrow(10000)`*³* | 0.060ms <span style="color:green">(23.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.025ms <span style="color:green">(57.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.024ms <span style="color:green">(59.1x)</span>&nbsp;🟢 | 0.045ms <span style="color:green">(31.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.025ms   <span style="color:green">(56.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.026ms   <span style="color:green">(55.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1.414ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `EnqueueGrow(100000)`*³* | 0.657ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.249ms  <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.231ms  <span style="color:green">(1.8x)</span>&nbsp;🟢 | 0.445ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.241ms    <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.248ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.407ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `EnqueueGrow(1000000)`*³* | 6.580ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 2.452ms  <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.340ms  <span style="color:green">(1.7x)</span>&nbsp;🟢 | 4.509ms  <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.473ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.509ms    <span style="color:green">(1.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.931ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Enqueue(10000)`*⁴* | 0.060ms  <span style="color:red">(0.8x)</span>&nbsp;🟠 | 0.019ms  <span style="color:green">(2.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms  <span style="color:green">(2.5x)</span>&nbsp;🟢 | 0.039ms  <span style="color:green">(1.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.020ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.020ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.046ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Enqueue(100000)`*⁴* | 0.599ms  <span style="color:red">(0.7x)</span>&nbsp;🟠 | 0.193ms  <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.180ms  <span style="color:green">(2.3x)</span>&nbsp;🟢 | 0.392ms  <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.198ms    <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.196ms    <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.407ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Enqueue(1000000)`*⁴* | 5.989ms  <span style="color:red">(0.7x)</span>&nbsp;🟠 | 2.048ms  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.801ms  <span style="color:green">(2.2x)</span>&nbsp;🟢 | 3.933ms  <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.010ms    <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 2.011ms    <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.933ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Dequeue(10000)` | 0.066ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.025ms  <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.016ms  <span style="color:green">(2.4x)</span>&nbsp;🟢 | 0.045ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms    <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.037ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Dequeue(100000)` | 0.664ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.248ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.151ms  <span style="color:green">(2.4x)</span>&nbsp;🟢 | 0.455ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.158ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.159ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.369ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Dequeue(1000000)` | 6.640ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 2.479ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.503ms  <span style="color:green">(2.5x)</span>&nbsp;🟢 | 4.551ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.578ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.589ms    <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.690ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Peek(10000)`*¹* | 0.030ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.023ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.014ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.012ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.000ms   <span style="color:green">(45.4x)</span>&nbsp;🟢 | 0.000ms   <span style="color:green">(45.4x)</span>&nbsp;🟢 | *0.018ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Peek(100000)`*¹* | 0.302ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 0.222ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.134ms  <span style="color:green">(1.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.121ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.001ms  <span style="color:green">(278.8x)</span>&nbsp;🟢 | 0.001ms  <span style="color:green">(258.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.181ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Peek(1000000)`*¹* | 3.016ms  <span style="color:red">(0.6x)</span>&nbsp;🟠 | 2.213ms  <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.369ms  <span style="color:green">(1.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.205ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.001ms <span style="color:green">(2127.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.001ms <span style="color:green">(2260.8x)</span>&nbsp;🟢 | *1.809ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Foreach(10000)` | 0.028ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.009ms  <span style="color:green">(4.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.007ms  <span style="color:green">(6.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.003ms   <span style="color:green">(13.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.003ms   <span style="color:green">(14.1x)</span>&nbsp;🟢 | *0.042ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(100000)` | 0.283ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.082ms  <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.062ms  <span style="color:green">(6.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.182ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.027ms   <span style="color:green">(15.5x)</span>&nbsp;🟢 | 0.027ms   <span style="color:green">(15.5x)</span>&nbsp;🟢 | *0.425ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Foreach(1000000)` | 2.833ms  <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.812ms  <span style="color:green">(5.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.612ms  <span style="color:green">(6.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.819ms  <span style="color:green">(2.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.267ms   <span style="color:green">(15.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.267ms   <span style="color:green">(15.9x)</span>&nbsp;🟢 | *4.250ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*¹* Optimizations were disabled to perform this benchmark<br/>
*³* EnqueueGrow(insertions)<br/>
*⁴* Enqueue(insertions)<br/>

---
<br/>

### *RingQueue*

| Functionality | NativeRingQueue (S) | NativeRingQueue (S+B) | NativeRingQueue (B) | UnsafeRingQueue (S) | UnsafeRingQueue (S+B) | UnsafeRingQueue (B) | *Queue (BCL)* |
|---|--:|--:|--:|--:|--:|--:|--:|
| `IsEmpty_x_100k(0)`*¹* | 0.174ms <span style="color:red">(0.7x)</span>&nbsp;🟠 | 0.108ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.108ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.121ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.110ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.121ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `IsEmpty_x_100k(100)`*¹* | 0.161ms <span style="color:red">(0.8x)</span>&nbsp;🟠 | 0.108ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms <span style="color:green">(1.1x)</span>&nbsp;🟢 | 0.120ms <span style="color:grey">(1.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.110ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.120ms <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `Count_x_100k(0)`*¹* | 0.192ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.142ms <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.108ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.120ms <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.101ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Count_x_100k(100)`*¹* | 0.188ms <span style="color:red">(0.5x)</span>&nbsp;🟠 | 0.143ms <span style="color:red">(0.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.110ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.120ms <span style="color:red">(0.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.111ms <span style="color:red">(0.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.100ms <span style="color:grey">(1.0x)</span>*&nbsp;🟢 |
| `Enqueue(10000)` | 0.033ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.019ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.018ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.019ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:green">(2.0x)</span>&nbsp;🟢 | 0.018ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.035ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(100000)` | 0.331ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.183ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.173ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.182ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.172ms <span style="color:green">(2.0x)</span>&nbsp;🟢 | 0.173ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.349ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Enqueue(1000000)` | 3.311ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.815ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.725ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.823ms <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.722ms <span style="color:green">(2.0x)</span>&nbsp;🟢 | 1.732ms <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.477ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Dequeue(10000)` | 0.032ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.008ms <span style="color:green">(4.6x)</span>&nbsp;🟢 | 0.017ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.017ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.011ms <span style="color:green">(3.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.035ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Dequeue(100000)` | 0.326ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.163ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.072ms <span style="color:green">(4.9x)</span>&nbsp;🟢 | 0.167ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.162ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.102ms <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *0.352ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `Dequeue(1000000)` | 3.257ms <span style="color:green">(1.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.624ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 0.708ms <span style="color:green">(5.0x)</span>&nbsp;🟢 | 1.666ms <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.612ms <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 1.008ms <span style="color:green">(3.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *3.516ms <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |

*¹* Optimizations were disabled to perform this benchmark<br/>

---
