# Performance Comparison: Allocators

> **<span style="color:red">This file is auto-generated</span>**
> 
> All measurments were taken on 12th Gen Intel(R) Core(TM) i9-12900K with 24 logical cores.<br/>
> Unity Editor version: 2022.2.8f1<br/>
> To regenerate this file locally use: **DOTS -> Unity.Collections -> Generate &ast;&ast;&ast;** menu.<br/>

## Table of Contents

- [Benchmark Results](#benchmark-results)
  - [RewindableAllocator](#rewindableallocator)

## Benchmark Results

The following benchmarks make **150 consecutive allocations** per sample set.<br/>Multithreaded benchmarks make the full **150 consecutive allocations *per worker thread*** per sample set.<br/>The **Min of 50 sample sets** is compared against the baseline on the far right side of the table.<br/>5 extra sample sets are run as warmup.<br/>
<br/>

> **Legend**
> 
> `(S)` = Safety Enabled<br/>
> `(B)` = Burst Compiled *with Safety Disabled*<br/>
> `(S+B)` = Burst Compiled *with Safety Enabled*<br/>
> `(E)` = Engine Provided<br/>
> <br/>
> *`italic`* results are for benchmarking comparison only; these are not included in standard Performance Framework tests<br/>

<br/>

### *RewindableAllocator*

| Functionality | RewindableAllocator (S) | RewindableAllocator (S+B) | RewindableAllocator (B) | *TempJob (E)* | *Temp (E)* | *Persistent (E)* |
|---|--:|--:|--:|--:|--:|--:|
| `FixedSize(1, 1024)`*³* | 11.4µs  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.0µs   <span style="color:green">(6.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 3.8µs   <span style="color:green">(6.6x)</span>&nbsp;🟢 | *17.0µs  <span style="color:green">(1.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *10.1µs   <span style="color:green">(2.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *25.1µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(2, 1024)`*²˒³* | 23.0µs  <span style="color:green">(2.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 23.1µs   <span style="color:green">(2.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 9.0µs   <span style="color:green">(5.2x)</span>&nbsp;🟢 | *20.2µs  <span style="color:green">(2.3x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.2µs   <span style="color:green">(4.2x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *47.2µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(4, 1024)`*²˒³* | 66.4µs  <span style="color:green">(1.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 71.9µs   <span style="color:green">(1.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 80.8µs   <span style="color:green">(1.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *23.5µs  <span style="color:green">(5.3x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.5µs  <span style="color:green">(10.7x)</span>*&nbsp;🟢 | *123.5µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(8, 1024)`*²˒³* | 167.1µs  <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 169.2µs   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 167.3µs   <span style="color:green">(2.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *45.6µs  <span style="color:green">(8.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *12.8µs  <span style="color:green">(28.6x)</span>*&nbsp;🟢 | *366.4µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(1, 1048576)`*³* | 11.9µs <span style="color:green">(16.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.7µs  <span style="color:green">(41.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.4µs  <span style="color:green">(44.1x)</span>&nbsp;🟢 | *17.1µs <span style="color:green">(11.4x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *10.9µs  <span style="color:green">(17.8x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *194.1µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(2, 1048576)`*²˒³* | 26.0µs <span style="color:green">(10.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.0µs  <span style="color:green">(15.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 14.1µs  <span style="color:green">(18.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *32.0µs  <span style="color:green">(8.1x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.7µs  <span style="color:green">(22.1x)</span>*&nbsp;🟢 | *258.9µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(4, 1048576)`*²˒³* | 70.1µs <span style="color:green">(11.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 71.3µs  <span style="color:green">(11.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 75.3µs  <span style="color:green">(10.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *208.5µs  <span style="color:green">(3.9x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *12.5µs  <span style="color:green">(65.0x)</span>*&nbsp;🟢 | *812.2µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `FixedSize(8, 1048576)`*²˒³* | 139.7µs <span style="color:green">(14.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 161.0µs  <span style="color:green">(12.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 179.8µs  <span style="color:green">(11.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1317.1µs  <span style="color:green">(1.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *19.5µs <span style="color:green">(104.6x)</span>*&nbsp;🟢 | *2039.9µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(1, 4096)`*⁴* | 11.9µs  <span style="color:green">(4.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.6µs  <span style="color:green">(10.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.3µs  <span style="color:green">(11.0x)</span>&nbsp;🟢 | *17.9µs  <span style="color:green">(2.6x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *10.3µs   <span style="color:green">(4.6x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *47.2µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(2, 4096)`*²˒⁴* | 26.8µs  <span style="color:green">(4.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.9µs  <span style="color:green">(11.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 10.5µs  <span style="color:green">(12.2x)</span>&nbsp;🟢 | *31.7µs  <span style="color:green">(4.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *10.9µs  <span style="color:green">(11.7x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *127.6µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(4, 4096)`*²˒⁴* | 58.9µs  <span style="color:green">(7.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 67.6µs   <span style="color:green">(6.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 64.5µs   <span style="color:green">(6.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *71.9µs  <span style="color:green">(6.2x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.2µs  <span style="color:green">(39.7x)</span>*&nbsp;🟢 | *444.7µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(8, 4096)`*²˒⁴* | 169.3µs  <span style="color:green">(7.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 159.0µs   <span style="color:green">(8.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 185.7µs   <span style="color:green">(7.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *350.8µs  <span style="color:green">(3.8x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.5µs <span style="color:green">(114.7x)</span>*&nbsp;🟢 | *1319.0µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(1, 65536)`*⁴* | 12.7µs <span style="color:green">(49.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 5.0µs <span style="color:green">(125.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.7µs <span style="color:green">(133.1x)</span>&nbsp;🟢 | *19.0µs <span style="color:green">(32.9x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.0µs  <span style="color:green">(56.9x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *625.4µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(2, 65536)`*²˒⁴* | 25.0µs <span style="color:green">(46.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 15.8µs  <span style="color:green">(73.3x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 13.0µs  <span style="color:green">(89.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *578.1µs  <span style="color:green">(2.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.3µs <span style="color:green">(102.5x)</span>*&nbsp;🟢 | *1157.7µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(4, 65536)`*²˒⁴* | 73.3µs <span style="color:green">(34.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 73.0µs  <span style="color:green">(34.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 70.5µs  <span style="color:green">(36.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2098.0µs  <span style="color:green">(1.2x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.9µs <span style="color:green">(213.6x)</span>*&nbsp;🟢 | *2542.2µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `IncSize(8, 65536)`*²˒⁴* | 141.3µs <span style="color:green">(40.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 168.1µs  <span style="color:green">(34.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 162.6µs  <span style="color:green">(35.2x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *6036.0µs  <span style="color:red">(0.9x)</span>*&nbsp;🟠 | *12.7µs <span style="color:green">(450.8x)</span>*&nbsp;🟢 | *5724.9µs <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |
| `DecSize(1, 4096)`*⁵* | 12.2µs  <span style="color:green">(6.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.6µs  <span style="color:green">(16.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.3µs  <span style="color:green">(17.2x)</span>&nbsp;🟢 | *16.9µs  <span style="color:green">(4.4x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *9.8µs   <span style="color:green">(7.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *73.9µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(2, 4096)`*²˒⁵* | 27.6µs  <span style="color:green">(3.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 12.5µs   <span style="color:green">(7.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.9µs   <span style="color:green">(8.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *37.3µs  <span style="color:green">(2.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.4µs   <span style="color:green">(8.3x)</span>*&nbsp;🟢 | *94.9µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(4, 4096)`*²˒⁵* | 68.5µs  <span style="color:green">(7.5x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 74.7µs   <span style="color:green">(6.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 69.4µs   <span style="color:green">(7.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *79.3µs  <span style="color:green">(6.5x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.0µs  <span style="color:green">(46.5x)</span>*&nbsp;🟢 | *511.6µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(8, 4096)`*²˒⁵* | 173.5µs  <span style="color:green">(7.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 173.4µs   <span style="color:green">(7.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 168.3µs   <span style="color:green">(7.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *313.4µs  <span style="color:green">(4.1x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *17.1µs  <span style="color:green">(75.1x)</span>*&nbsp;🟢 | *1284.6µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(1, 65536)`*⁵* | 12.1µs <span style="color:green">(47.9x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.6µs <span style="color:green">(126.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 4.3µs <span style="color:green">(134.8x)</span>&nbsp;🟢 | *20.8µs <span style="color:green">(27.9x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *11.7µs  <span style="color:green">(49.6x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *579.8µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(2, 65536)`*²˒⁵* | 28.6µs <span style="color:green">(37.1x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 17.7µs  <span style="color:green">(60.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 11.5µs  <span style="color:green">(92.3x)</span>&nbsp;🟢 | *658.8µs  <span style="color:green">(1.6x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *12.5µs  <span style="color:green">(84.9x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *1061.4µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(4, 65536)`*²˒⁵* | 67.3µs <span style="color:green">(38.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 69.4µs  <span style="color:green">(37.6x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 73.1µs  <span style="color:green">(35.7x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *2386.4µs  <span style="color:green">(1.1x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *14.2µs <span style="color:green">(183.8x)</span>*&nbsp;🟢 | *2609.3µs <span style="color:grey">(1.0x)</span>*&nbsp;🟠 |
| `DecSize(8, 65536)`*²˒⁵* | 154.4µs <span style="color:green">(37.8x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 166.6µs  <span style="color:green">(35.0x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | 155.9µs  <span style="color:green">(37.4x)</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | *5938.8µs  <span style="color:grey">(1.0x)</span>*&nbsp;🟠 | *28.6µs <span style="color:green">(203.9x)</span>*&nbsp;🟢 | *5830.8µs <span style="color:grey">(1.0x)</span>*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; |

*²* Benchmark run on parallel job workers - results may vary<br/>
*³* FixedSize(workerThreads, allocSize)<br/>
*⁴* IncSize(workerThreads, allocSize) -- Makes linearly increasing allocations [1⋅allocSize, 2⋅allocSize ... N⋅allocSize]<br/>
*⁵* DecSize(workerThreads, allocSize) -- Makes linearly decreasing allocations [N⋅allocSize ... 2⋅allocSize, 1⋅allocSize]<br/>

---
