using UnityEngine;

public class TrayToggle : MonoBehaviour
{
    public GameObject trayPanel;          // The panel to animate
    private Animator trayAnimator;        // Animator controlling the tray
    private bool isVisible = false;       // Current tray visibility

    void Start()
    {
        trayAnimator = trayPanel.GetComponent<Animator>();
        trayAnimator.SetBool("IsVisible", isVisible);  // Ensure correct startup state
    }

    public void ToggleTray()
    {
        isVisible = !isVisible;
        Debug.Log("Toggling tray. New state: " + isVisible);
        trayAnimator.SetBool("IsVisible", isVisible);
    }
}
