using UnityEngine;
using UnityEngine.UI;

public class OpacityController : MonoBehaviour
{
    public Renderer[] targetQuads;
    public Slider opacitySlider;

    void Start()
    {
        opacitySlider.onValueChanged.AddListener(SetOpacity);
        SetOpacity(opacitySlider.value); // initialize on start
    }

    void SetOpacity(float value)
    {
        foreach (Renderer quadRenderer in targetQuads)
        {
            Color currentColor = quadRenderer.material.color;
            currentColor.a = value;
            quadRenderer.material.color = currentColor;
        }
    }
}
