/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import com.google.androidgamesdk.GameActivity;
import com.unity3d.player.IUnityPermissionRequestSupport;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.IUnityPlayerSupport;
import com.unity3d.player.PermissionRequest;
import com.unity3d.player.UnityPlayerForGameActivity;

public class UnityPlayerGameActivity
extends GameActivity
implements IUnityPlayerLifecycleEvents,
IUnityPermissionRequestSupport,
IUnityPlayerSupport {
    protected UnityPlayerForGameActivity mUnityPlayer;

    protected String updateUnityCommandLineArguments(String cmdLine) {
        return cmdLine;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public UnityPlayerForGameActivity getUnityPlayerConnection() {
        return this.mUnityPlayer;
    }

    private void applyInsetListener(SurfaceView surfaceView) {
        surfaceView.getViewTreeObserver().addOnGlobalLayoutListener(() -> this.onApplyWindowInsets((View)surfaceView, ViewCompat.getRootWindowInsets((View)this.getWindow().getDecorView())));
    }

    protected GameActivity.InputEnabledSurfaceView createSurfaceView() {
        return new GameActivitySurfaceView(this);
    }

    protected void onCreateSurfaceView() {
        super.onCreateSurfaceView();
        FrameLayout frameLayout = (FrameLayout)this.findViewById(this.contentViewId);
        this.applyInsetListener((SurfaceView)this.mSurfaceView);
        this.mSurfaceView.setId(UnityPlayerForGameActivity.getUnityViewIdentifier((Context)this));
        String cmdLine = this.updateUnityCommandLineArguments(this.getIntent().getStringExtra("unity"));
        this.getIntent().putExtra("unity", cmdLine);
        this.mUnityPlayer = new UnityPlayerForGameActivity((Activity)this, frameLayout, (SurfaceView)this.mSurfaceView, (IUnityPlayerLifecycleEvents)this);
    }

    public void onUnityPlayerUnloaded() {
    }

    public void onUnityPlayerQuitted() {
    }

    protected void onDestroy() {
        this.mUnityPlayer.destroy();
        super.onDestroy();
    }

    protected void onStop() {
        this.mUnityPlayer.onStop();
        super.onStop();
    }

    protected void onStart() {
        this.mUnityPlayer.onStart();
        super.onStart();
    }

    protected void onPause() {
        this.mUnityPlayer.onPause();
        super.onPause();
    }

    protected void onResume() {
        this.mUnityPlayer.onResume();
        super.onResume();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mUnityPlayer.configurationChanged(newConfig);
        super.onConfigurationChanged(newConfig);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.mUnityPlayer.windowFocusChanged(hasFocus);
        super.onWindowFocusChanged(hasFocus);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.mUnityPlayer.newIntent(intent);
    }

    @TargetApi(value=23)
    public void requestPermissions(PermissionRequest request) {
        this.mUnityPlayer.addPermissionRequest(request);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.mUnityPlayer.permissionResponse((Activity)this, requestCode, permissions, grantResults);
    }

    static {
        System.loadLibrary("game");
    }

    class GameActivitySurfaceView
    extends GameActivity.InputEnabledSurfaceView {
        GameActivity mGameActivity;

        public GameActivitySurfaceView(GameActivity activity) {
            super((GameActivity)UnityPlayerGameActivity.this, activity);
            this.mGameActivity = activity;
        }

        public boolean onCapturedPointerEvent(MotionEvent event) {
            return this.mGameActivity.onTouchEvent(event);
        }
    }
}

