/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.FrameLayout;
import com.unity3d.player.A;
import com.unity3d.player.A0;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.B0;
import com.unity3d.player.C;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.D;
import com.unity3d.player.DisplayCutoutSupport;
import com.unity3d.player.E;
import com.unity3d.player.E1;
import com.unity3d.player.G;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.H;
import com.unity3d.player.H0;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.I0;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.J0;
import com.unity3d.player.K0;
import com.unity3d.player.L0;
import com.unity3d.player.M0;
import com.unity3d.player.MultiWindowSupport;
import com.unity3d.player.N0;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.O0;
import com.unity3d.player.OrientationLockListener;
import com.unity3d.player.P0;
import com.unity3d.player.P1;
import com.unity3d.player.PermissionRequest;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.Q0;
import com.unity3d.player.Q1;
import com.unity3d.player.R0;
import com.unity3d.player.S0;
import com.unity3d.player.T0;
import com.unity3d.player.U0;
import com.unity3d.player.UnityAccessibilityDelegate;
import com.unity3d.player.UnityGameManager;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.V0;
import com.unity3d.player.X0;
import com.unity3d.player.Y0;
import com.unity3d.player.Z0;
import com.unity3d.player.a.a;
import com.unity3d.player.a.d;
import com.unity3d.player.a.g;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.fmod.FmodAndroidAudioManager;

public abstract class UnityPlayer
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity;
    public static Context currentContext;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String LAUNCH_FULLSCREEN = "unity.launch-fullscreen";
    private static final String ARCORE_ENABLE_METADATA_NAME = "unity.arcore-enable";
    private static final String AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME = "unity.auto-report-fully-drawn";
    private static final String AUTO_SET_GAME_STATE_ENABLE_METADATA_NAME = "unity.auto-set-game-state";
    Handler mHandler;
    private A mContextType;
    private int mInitialScreenOrientation;
    private boolean mIsFullscreen;
    E1 mState;
    private OrientationEventListener mOrientationListener;
    int mNaturalOrientation;
    private Configuration prevConfig;
    boolean m_AddPhoneCallListener;
    Y0 m_PhoneCallListener;
    TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private g m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi;
    private V0 m_FakeListener;
    private Camera2Wrapper m_Camera2Wrapper;
    private HFPStatus m_HFPStatus;
    private AudioVolumeHandler m_AudioVolumeHandler;
    private OrientationLockListener m_OrientationLockListener;
    private FmodAndroidAudioManager m_FmodAndroidAudioManager;
    private E m_NetworkConnectivity;
    private G m_OnBackPressedDispatcher;
    private FrameLayout m_FrameLayout;
    private A0 m_Cursor;
    private Thread m_UIThread;
    protected IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents;
    private HashMap m_PermissionRequests;
    Window m_Window;
    private UnityAccessibilityDelegate m_AccessibilityDelegate;
    private final ConcurrentLinkedQueue m_MainThreadJobs;
    Context mContext;
    Activity mActivity;
    boolean mQuitting;
    private Q1 mVideoPlayerProxy;

    protected UnityPlayer(Context context, A a2, IUnityPlayerLifecycleEvents iUnityPlayerLifecycleEvents) {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        V0 v02;
        Y0 y02;
        E1 e12;
        Handler handler;
        Object object = handler;
        handler = new Handler();
        this.mHandler = object;
        this.mInitialScreenOrientation = -1;
        this.mIsFullscreen = true;
        object = e12;
        e12 = new E1();
        this.mState = object;
        this.mOrientationListener = null;
        this.m_AddPhoneCallListener = false;
        object = y02;
        y02 = new Y0(this);
        this.m_PhoneCallListener = object;
        this.m_ARCoreApi = null;
        object = v02;
        v02 = new V0();
        this.m_FakeListener = object;
        this.m_Camera2Wrapper = null;
        this.m_HFPStatus = null;
        this.m_AudioVolumeHandler = null;
        this.m_OrientationLockListener = null;
        this.m_FmodAndroidAudioManager = null;
        this.m_NetworkConnectivity = null;
        this.m_OnBackPressedDispatcher = null;
        this.m_Cursor = null;
        this.m_UnityPlayerLifecycleEvents = null;
        this.m_AccessibilityDelegate = null;
        object = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.m_MainThreadJobs = object;
        this.m_UIThread = Thread.currentThread();
        this.mContext = context;
        this.mContextType = a2;
        if (iUnityPlayerLifecycleEvents == null) {
            iUnityPlayerLifecycleEvents = this;
        }
        Context context2 = context;
        this.m_UnityPlayerLifecycleEvents = iUnityPlayerLifecycleEvents;
        B0.a(UnityPlayer.getUnityNativeLibraryPath(context2));
        currentContext = context2;
        if (context2 instanceof Activity) {
            currentActivity = this.mActivity = (Activity)context;
            this.mInitialScreenOrientation = this.mActivity.getRequestedOrientation();
        }
    }

    private void developmentPlayerInitialize() {
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 != 0 && n3 != 2 || n2 != 2) && (n3 != 1 && n3 != 3 || n2 != 1)) {
            return 1;
        }
        return 0;
    }

    private String GetGlViewContentDescription(Context context) {
        String string = context.getPackageName();
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", string));
    }

    private void EarlyEnableFullScreenIfEnabled() {
        Activity activity = this.mActivity;
        if (activity != null && activity.getWindow() != null && (this.getLaunchFullscreen() || this.mActivity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false))) {
            this.applyWindowUIChanges(true);
        }
        DisplayCutoutSupport.setLayoutCutoutMode(this.mActivity);
    }

    private boolean isWindowTranslucent() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer == null) {
            return false;
        }
        unityPlayer = unityPlayer.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = unityPlayer.getBoolean(0, false);
        unityPlayer.recycle();
        return bl;
    }

    public static void UnitySendMessage(String string, String string2, String object) {
        if (!E1.d()) {
            D.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        if (object == null) {
            object = null;
        } else {
            object = ((String)object).getBytes("UTF-8");
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, (byte[])object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void requestUserAuthorization(String string, long l2) {
        Activity activity;
        if (string != null && !string.isEmpty() && (activity = stringArray2.mActivity) != null) {
            X0 x02 = null;
            if (l2 != 0L) {
                X0 x03;
                x02 = x03;
                x03 = new X0((UnityPlayer)stringArray2, l2);
            }
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            UnityPermissions.requestUserPermissions(activity, stringArray2, x02);
        }
    }

    static native void permissionResponseToNative(long var0, boolean var2);

    private final native void initJni(Context var1, int var2);

    private final native void nativeApplicationUnload();

    private final native boolean nativeInjectEvent(InputEvent var1, int var2);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeHidePreservedContent();

    private final native void nativeViewPaddingChanged(int var1, int var2, int var3, int var4, int var5);

    private static String logLoadLibMainError(String string, String string2) {
        String string3 = "Failed to load 'libmain.so'\n\n" + string2;
        D.Log(6, string3);
        return string3;
    }

    private static void preloadJavaPlugins() {
        try {
            Class.forName("com.unity3d.JavaPluginPreloader");
        }
        catch (LinkageError linkageError) {
            D.Log(6, "Java class preloading failed: " + linkageError.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadNative(String var0) {
        var1_1 = var0 + "/libmain.so";
        try {
            System.load(var1_1);
            ** GOTO lbl12
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                System.loadLibrary("main");
            }
            catch (SecurityException v1) {
                return UnityPlayer.logLoadLibMainError(var1_1, v1.toString());
            }
lbl12:
            // 2 sources

            if (NativeLoader.load(var0)) {
                E1.e();
                return "";
            }
            D.Log(6, "NativeLoader.load failure, Unity libraries were not loaded.");
            return "NativeLoader.load failure, Unity libraries were not loaded.";
            catch (UnsatisfiedLinkError v2) {
                return UnityPlayer.logLoadLibMainError(var1_1, v2.toString());
            }
        }
    }

    private static void unloadNative() {
        if (!E1.d()) {
            return;
        }
        if (NativeLoader.unload()) {
            E1.f();
            return;
        }
        throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
    }

    private static String getUnityNativeLibraryPath(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    private static native void nativeSetLaunchURL(String var0);

    private String getProcessName() {
        int n2 = Process.myPid();
        Object object = ((ActivityManager)this.mContext.getSystemService("activity")).getRunningAppProcesses();
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (runningAppProcessInfo.pid != n2) continue;
            return runningAppProcessInfo.processName;
        }
        return null;
    }

    private ActivityInfo getActivityInfo() {
        return this.mActivity.getPackageManager().getActivityInfo(this.mActivity.getComponentName(), 128);
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getLaunchFullscreen() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(LAUNCH_FULLSCREEN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void hideStatusBar() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            unityPlayer.getWindow().setFlags(1024, 1024);
        }
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
            bl = true;
        }
        FrameLayout frameLayout = this.getFrameLayout();
        if (view != null && (viewParent = view.getParent()) != frameLayout) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            FrameLayout frameLayout2 = frameLayout;
            frameLayout2.addView(view);
            frameLayout2.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == frameLayout) {
            view2.setVisibility(8);
            frameLayout.removeView(view2);
        }
        if (bl) {
            this.setupUnityToBeResumed();
        }
    }

    private void invokeOnMainThread(Z0 z02) {
        if (this.isFinishing()) {
            return;
        }
        this.invokeOnMainThread((Runnable)z02);
    }

    private boolean runningOnUIThread() {
        return Thread.currentThread() == this.m_UIThread;
    }

    private void requestPointerCapture() {
        this.m_Cursor.b();
    }

    private void releasePointerCapture() {
        this.m_Cursor.a();
    }

    private void setBackButtonLeavesApp(boolean bl) {
        G g2 = ((UnityPlayer)((Object)g2)).m_OnBackPressedDispatcher;
        if (g2 != null) {
            if (bl ^ true) {
                g2.registerOnBackPressedCallback();
            } else {
                g2.unregisterOnBackPressedCallback();
            }
        }
    }

    private void setScreenBrightness(float f2) {
        f2 = Math.max(0.04f, f2);
        if (this.m_Window != null && this.getScreenBrightness() != f2) {
            U0 u02;
            U0 u03 = u02;
            u02 = new U0(this, f2);
            this.runOnUiThread(u03);
            return;
        }
    }

    private float getScreenBrightness() {
        float f2;
        Window window = this.m_Window;
        if (window == null) {
            return 1.0f;
        }
        float f3 = window.getAttributes().screenBrightness;
        if (f2 < 0.0f) {
            int n2 = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness", (int)255);
            if (PlatformSupport.PIE_SUPPORT) {
                double d2 = (Math.log(n2) * 19.811 - 9.411) / 100.0;
                d2 = Math.min(1.0, d2);
                return (float)Math.max(0.0, d2);
            }
            return (float)n2 / 255.0f;
        }
        return f3;
    }

    private void pauseJavaAndCallUnloadCallback() {
        H0 h02;
        H0 h03 = h02;
        h02 = new H0(this);
        this.runOnUiThread(h03);
    }

    private boolean supportsWindowInsetController() {
        return PlatformSupport.RED_VELVET_CAKE_SUPPORT;
    }

    private void dispatchFrameLayoutPadding() {
        if (!E1.d()) {
            return;
        }
        UnityPlayer unityPlayer = this;
        FrameLayout frameLayout = unityPlayer.getFrameLayout();
        int n2 = frameLayout.getPaddingLeft();
        int n3 = frameLayout.getPaddingTop();
        int n4 = frameLayout.getPaddingRight();
        int n5 = frameLayout.getPaddingBottom();
        unityPlayer.nativeViewPaddingChanged(0, n2, n3, n4, n5);
    }

    private void applyWindowUIChanges(boolean bl) {
        Object object = this.mActivity;
        if (object != null && object.getWindow() != null) {
            I0 i02;
            object = i02;
            i02 = new I0(this, bl);
            this.runOnUiThread((Runnable)object);
            return;
        }
    }

    private void applyWindowInsets() {
        Object object = this.mActivity;
        if (object != null && object.getWindow() != null) {
            J0 j02;
            object = j02;
            j02 = new J0(this);
            this.runOnUiThread((Runnable)object);
            return;
        }
    }

    private void startActivityIndicator(int n2) {
        K0 k02;
        K0 k03 = k02;
        k02 = new K0(this, n2);
        this.postOnUiThread(k03);
    }

    private void stopActivityIndicator() {
        L0 l02;
        UnityPlayer unityPlayer = l03;
        L0 l03 = l02;
        l02 = new L0();
        unityPlayer.postOnUiThread(l03);
    }

    static {
        new B0().a();
    }

    public Context getContext() {
        return this.mContext;
    }

    Activity getActivity() {
        return this.mActivity;
    }

    A getContextType() {
        return this.mContextType;
    }

    protected void initialize(FrameLayout object) {
        N0 n02;
        A0 a02;
        HFPStatus hFPStatus;
        Camera2Wrapper camera2Wrapper;
        this.m_FrameLayout = object;
        this.EarlyEnableFullScreenIfEnabled();
        this.prevConfig = this.getFrameLayout().getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(this.prevConfig.orientation);
        if (this.mActivity != null && this.getSplashEnabled()) {
            g g2;
            object = g2;
            g2 = new g(this.mContext, a.b(3)[this.getSplashMode()]);
            this.m_SplashScreen = object;
            this.m_FrameLayout.addView((View)object);
            this.m_FrameLayout.bringChildToFront((View)this.m_SplashScreen);
        }
        UnityPlayer.preloadJavaPlugins();
        object = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(this.mContext));
        if (!E1.d()) {
            M0 m02;
            D.Log(6, "Your hardware does not support this application.");
            M0 m03 = m02;
            m02 = new M0(this);
            AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)m03).setMessage((CharSequence)("Your hardware does not support this application.\n\n" + (String)object + "\n\n Press OK to quit.")).create();
            alertDialog.setCancelable(false);
            alertDialog.show();
            return;
        }
        int n2 = this.mContextType.a;
        this.initJni(this.mContext, n2);
        this.mState.d(true);
        this.mQuitting = false;
        this.developmentPlayerInitialize();
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        Object object2 = camera2Wrapper;
        camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_Camera2Wrapper = object2;
        object2 = hFPStatus;
        hFPStatus = new HFPStatus(this.mContext);
        this.m_HFPStatus = object2;
        object2 = a02;
        a02 = new A0(this);
        this.m_Cursor = object2;
        this.m_FmodAndroidAudioManager = FmodAndroidAudioManager.getInstance();
        this.m_FmodAndroidAudioManager.setActivity(this.mActivity);
        object2 = n02;
        n02 = new N0(this);
        this.m_OnBackPressedDispatcher = H.a(this.getContext(), 1, (Runnable)object2);
        object2 = this.mActivity;
        if (object2 != null) {
            this.m_Window = object2.getWindow();
        }
    }

    boolean isNativeInitialized() {
        return E1.d() && this.mState.a();
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
        } else {
            sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
        }
    }

    void disableStaticSplashScreen() {
        O0 o02;
        O0 o03 = o02;
        o02 = new O0(this);
        this.runOnUiThread(o03);
    }

    protected void applySurfaceViewSettings(SurfaceView surfaceView) {
        if (this.isWindowTranslucent()) {
            SurfaceView surfaceView2 = surfaceView;
            surfaceView2.getHolder().setFormat(-3);
            surfaceView2.setZOrderOnTop(true);
        } else {
            surfaceView.getHolder().setFormat(-1);
        }
    }

    void finish() {
        Activity activity = this.mActivity;
        if (activity != null && !activity.isFinishing()) {
            this.mActivity.finish();
        }
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        Activity activity = this.mActivity;
        if (activity != null) {
            activity.runOnUiThread(runnable);
        } else if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public abstract View getView();

    public void newIntent(Intent intent) {
        this.setLaunchURL(intent.getData());
    }

    public void destroy() {
        Object object = this.m_Camera2Wrapper;
        if (object != null) {
            ((Camera2Wrapper)object).closeCamera2();
            this.m_Camera2Wrapper = null;
        }
        if ((object = this.m_HFPStatus) != null) {
            ((HFPStatus)object).b();
            this.m_HFPStatus = null;
        }
        if ((object = this.m_FmodAndroidAudioManager) != null) {
            ((FmodAndroidAudioManager)object).setActivity(null);
        }
        if ((object = this.m_NetworkConnectivity) != null) {
            ((E)object).a();
            this.m_NetworkConnectivity = null;
        }
        if ((object = this.m_OnBackPressedDispatcher) != null) {
            ((G)object).unregisterOnBackPressedCallback();
            this.m_OnBackPressedDispatcher = null;
        }
        this.mQuitting = true;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
        }
        this.cleanupResourcesForDestroy();
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        D.Log(4, "Quitting process");
        Process.killProcess((int)Process.myPid());
    }

    public void onStop() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onStart() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void onPause() {
        UnityPlayer unityPlayer = this;
        MultiWindowSupport.saveMultiWindowMode(unityPlayer.mActivity);
        if (MultiWindowSupport.isInMultiWindowMode(unityPlayer.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onResume() {
        if (MultiWindowSupport.isInMultiWindowMode(this.mActivity) && !MultiWindowSupport.isMultiWindowModeChangedToTrue(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void pause() {
        this.setupUnityToBePaused();
    }

    protected void setupUnityToBePaused() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).pauseARCore();
        }
        if ((object = this.mVideoPlayerProxy) != null) {
            ((Q1)object).b();
        }
        if ((object = this.m_AudioVolumeHandler) != null) {
            ((AudioVolumeHandler)object).a();
            this.m_AudioVolumeHandler = null;
        }
        if ((object = this.m_OrientationLockListener) != null) {
            ((OrientationLockListener)object).a();
            this.m_OrientationLockListener = null;
        }
        if ((object = this.m_OnBackPressedDispatcher) != null) {
            boolean bl = ((G)object).a != null;
            ((G)object).c = bl;
            ((G)object).unregisterOnBackPressedCallback();
        }
        if (this.canPauseUnity()) {
            this.pauseUnity();
        }
    }

    protected boolean canPauseUnity() {
        return this.mState.c() || !this.mState.b();
    }

    void pauseUnity() {
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.c(false);
        unityPlayer.mState.e(true);
    }

    protected boolean canResumeUnity() {
        boolean bl = false;
        Activity activity = this.mActivity;
        if (activity != null) {
            bl = MultiWindowSupport.isInMultiWindowMode(activity);
        }
        return this.mState.a(bl);
    }

    void resumeUnity() {
        this.mState.c(true);
    }

    public void resume() {
        this.setupUnityToBeResumed();
    }

    protected void setupUnityToBeResumed() {
        Object object = ((UnityPlayer)this).m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).resumeARCore();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.e(false);
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((Q1)object).c();
        }
        if (((UnityPlayer)this).canResumeUnity()) {
            ((UnityPlayer)this).resumeUnity();
        }
        if (((UnityPlayer)this).m_AudioVolumeHandler == null) {
            ((UnityPlayer)this).m_AudioVolumeHandler = new AudioVolumeHandler(((UnityPlayer)this).mContext);
        }
        if (((UnityPlayer)this).m_OrientationLockListener == null && E1.d()) {
            ((UnityPlayer)this).m_OrientationLockListener = new OrientationLockListener(((UnityPlayer)this).mContext);
        }
        if ((this = ((UnityPlayer)this).m_OnBackPressedDispatcher) != null && ((G)this).c) {
            ((G)this).registerOnBackPressedCallback();
        }
    }

    void shutdown() {
        this.mState.d(false);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    protected boolean skipPermissionsDialog() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            return UnityPermissions.skipPermissionsDialog((Activity)unityPlayer);
        }
        return false;
    }

    public synchronized void addPermissionRequest(PermissionRequest permissionRequest) {
        if (stringArray2.m_PermissionRequests == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            stringArray2.m_PermissionRequests = hashMap2;
        }
        int n2 = 1;
        while (true) {
            Integer n3;
            if (!stringArray2.m_PermissionRequests.containsKey(n3 = Integer.valueOf(n2))) {
                stringArray2.m_PermissionRequests.put(n3, permissionRequest);
                if (stringArray2.m_PermissionRequests.size() == 1) {
                    String[] stringArray = stringArray2;
                    String[] stringArray2 = permissionRequest.getPermissionNames();
                    stringArray.requestPermissionsFromActivity(stringArray2, n3);
                }
                return;
            }
            ++n2;
        }
    }

    public void requestPermissionsFromActivity(String[] stringArray, int n2) {
        this.mActivity.requestPermissions(stringArray, n2);
    }

    public synchronized void triggerNextPermissionRequest() {
        Object object = ((UnityPlayer)((Object)entry)).m_PermissionRequests;
        if (object != null && (object = ((HashMap)object).entrySet().iterator()) != null && object.hasNext()) {
            UnityPlayer unityPlayer = entry;
            Map.Entry entry = (Map.Entry)object.next();
            unityPlayer.requestPermissionsFromActivity(((PermissionRequest)entry.getValue()).getPermissionNames(), (Integer)entry.getKey());
        }
    }

    public synchronized void permissionResponse(Activity activity, int n2, String[] stringArray, int[] nArray) {
        P0 p02;
        if (((UnityPlayer)((Object)p03)).m_PermissionRequests == null) {
            return;
        }
        String[] stringArray2 = Integer.valueOf(n2);
        PermissionRequest permissionRequest = (PermissionRequest)((UnityPlayer)((Object)p03)).m_PermissionRequests.get(stringArray2);
        if (permissionRequest == null) {
            return;
        }
        ((UnityPlayer)((Object)p03)).m_PermissionRequests.remove(stringArray2);
        stringArray2 = permissionRequest.getPermissionNames();
        int[] nArray2 = new int[stringArray2.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n3 = -1;
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                if (!string.equals(stringArray2[i3])) continue;
                n3 = i3;
                break;
            }
            if (n3 < 0) {
                D.Log(6, "Permission not found in request: " + string);
                continue;
            }
            int n4 = nArray[i2] == 0 ? 1 : (Build.VERSION.SDK_INT >= 30 || UnityPermissions.shouldShowRequestPermissionRationale(activity, string) ? 2 : 3);
            nArray2[n3] = n4;
        }
        UnityPlayer unityPlayer = p03;
        P0 p03 = p02;
        p02 = new P0(permissionRequest, stringArray2, nArray2);
        unityPlayer.invokeOnMainThread(p03);
        unityPlayer.triggerNextPermissionRequest();
    }

    protected int getNetworkConnectivity() {
        E e2 = this.m_NetworkConnectivity;
        if (e2 != null) {
            return e2.b();
        }
        this.m_NetworkConnectivity = PlatformSupport.NOUGAT_SUPPORT ? new d(this.mContext) : new E(this.mContext);
        return this.m_NetworkConnectivity.b();
    }

    protected void setAccessibilityDelegate(UnityAccessibilityDelegate unityAccessibilityDelegate) {
        this.m_AccessibilityDelegate = unityAccessibilityDelegate;
    }

    public void configurationChanged(Configuration configuration) {
        Configuration configuration2;
        int n2 = ((UnityPlayer)this).prevConfig.diff(configuration);
        if ((n2 & 0x100) != 0 || (n2 & 0x400) != 0 || (n2 & 0x800) != 0 || (n2 & 0x80) != 0) {
            ((UnityPlayer)this).nativeHidePreservedContent();
        }
        Object object = configuration2;
        configuration2 = new Configuration(configuration);
        ((UnityPlayer)this).prevConfig = object;
        object = ((UnityPlayer)this).mVideoPlayerProxy;
        if (object != null) {
            ((Q1)object).a();
        }
        if ((this = ((UnityPlayer)this).m_AccessibilityDelegate) != null) {
            ((UnityAccessibilityDelegate)((Object)this)).a(configuration);
        }
    }

    abstract boolean handleFocus(boolean var1);

    public void windowFocusChanged(boolean bl) {
        this.mState.b(bl);
        if (!this.handleFocus(bl)) {
            return;
        }
        if (this.canResumeUnity()) {
            this.resumeUnity();
        }
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    protected void setClipboardText(String string) {
        UnityPlayer unityPlayer = unityPlayer2;
        UnityPlayer unityPlayer2 = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        unityPlayer.m_ClipboardManager.setPrimaryClip((ClipData)unityPlayer2);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer == null) {
            return null;
        }
        return (unityPlayer = unityPlayer.getIntent().getData()) != null ? unityPlayer.toString() : null;
    }

    void setLaunchURL(Uri object) {
        Q0 q02;
        object = object != null ? object.toString() : null;
        UnityPlayer unityPlayer = q03;
        Q0 q03 = q02;
        q02 = new Q0((String)object);
        unityPlayer.invokeOnMainThread(q03);
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && this.mActivity != null && this.getARCoreEnabled()) {
            GoogleARCoreApi googleARCoreApi;
            GoogleARCoreApi googleARCoreApi2;
            GoogleARCoreApi googleARCoreApi3 = googleARCoreApi2 = googleARCoreApi;
            googleARCoreApi3();
            this.m_ARCoreApi = googleARCoreApi3;
            googleARCoreApi.initializeARCore(this.mActivity);
            if (!this.mState.b()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        R0 r02;
        if (this.mVideoPlayerProxy == null) {
            Q1 q12;
            Q1 q13 = q12;
            q12 = new Q1(this);
            this.mVideoPlayerProxy = q13;
        }
        Object object = this.mContext;
        long l2 = n5;
        long l3 = n6;
        Context context = object;
        object = r02;
        r02 = new R0(this);
        boolean bl2 = this.mVideoPlayerProxy.a(context, string, n2, n3, n4, bl, l2, l3, (P1)object);
        if (bl2) {
            S0 s02;
            S0 s03 = s02;
            s02 = new S0(this);
            this.runOnUiThread(s03);
        }
        return bl2;
    }

    protected boolean isUaaLUseCase() {
        Object object = this.mActivity;
        if (object != null) {
            return (object = object.getCallingPackage()) != null && ((String)object).equals(this.mContext.getPackageName());
        }
        return false;
    }

    protected int getUaaLLaunchProcessType() {
        String string = this.getProcessName();
        return string != null && !string.equals(this.mContext.getPackageName()) ? 1 : 0;
    }

    ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    boolean getAutoSetGameStateEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(AUTO_SET_GAME_STATE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean shouldSetGameState() {
        if (!PlatformSupport.TIRAMISU_SUPPORT) {
            return false;
        }
        if (this.mActivity == null) {
            return false;
        }
        return !this.isUaaLUseCase() && this.getAutoSetGameStateEnabled() && UnityGameManager.getGameManager(currentContext) != null;
    }

    boolean getAutoReportFullyDrawnEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean shouldReportFullyDrawn() {
        if (this.mActivity == null) {
            return false;
        }
        return this.getAutoReportFullyDrawnEnabled();
    }

    void reportFullyDrawn() {
        this.mActivity.reportFullyDrawn();
    }

    protected void disableLogger() {
        D.a = true;
    }

    protected boolean isFinishing() {
        if (this.mQuitting) {
            return true;
        }
        Activity activity = this.mActivity;
        if (activity != null) {
            this.mQuitting = activity.isFinishing();
        }
        return this.mQuitting;
    }

    public boolean injectEvent(InputEvent inputEvent) {
        return this.injectEvent(inputEvent, 0);
    }

    public boolean injectEvent(InputEvent inputEvent, int n2) {
        if (!E1.d()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent, n2);
    }

    public abstract SurfaceView getSurfaceView();

    public boolean addViewToPlayer(View view, boolean bl) {
        View view2 = unityPlayer2.getView();
        Object object = bl ? view2 : null;
        UnityPlayer unityPlayer = unityPlayer2;
        unityPlayer.swapViews(view, (View)object);
        UnityPlayer unityPlayer2 = unityPlayer.getFrameLayout();
        boolean bl2 = view.getParent() == unityPlayer2;
        bl = bl && view2.getParent() == null;
        boolean bl3 = view2.getParent() == unityPlayer2;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                D.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                D.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        UnityPlayer unityPlayer = this;
        View view2 = unityPlayer.getView();
        unityPlayer.swapViews(view2, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = view2.getParent() == this.getFrameLayout();
        if (!(bl && bl2)) {
            if (!bl) {
                D.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                D.Log(6, "removeViewFromPlayer: Failure adding old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        D.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String string) {
        block8: {
            String string2;
            Object object;
            block7: {
                block6: {
                    if (!string.startsWith("http:")) break block6;
                    object = "http.proxyHost";
                    string = "http.proxyPort";
                    string2 = "http.nonProxyHosts";
                    break block7;
                }
                if (!string.startsWith("https:")) break block8;
                object = "https.proxyHost";
                string = "https.proxyPort";
                string2 = "http.nonProxyHosts";
            }
            object = System.getProperties().getProperty((String)object);
            if (object != null && !"".equals(object)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder((String)object);
                object = System.getProperties().getProperty(string);
                if (object != null && !"".equals(object)) {
                    stringBuilder2.append(":").append((String)object);
                }
                if ((object = System.getProperties().getProperty(string2)) != null && !"".equals(object)) {
                    stringBuilder2.append('\n').append((String)object);
                }
                return stringBuilder2.toString();
            }
            return null;
        }
        return null;
    }

    public boolean startOrientationListener(int n2) {
        T0 t02;
        if (this.mOrientationListener != null) {
            D.Log(5, "Orientation Listener already started.");
            return false;
        }
        T0 t03 = t02;
        UnityPlayer unityPlayer = this;
        this.mOrientationListener = new T0(unityPlayer, unityPlayer.mContext, n2);
        if (t03.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        D.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener == null) {
            D.Log(5, "Orientation Listener was not started.");
            return false;
        }
        orientationEventListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    public void invokeOnMainThread(Runnable runnable) {
        if (!E1.d()) {
            return;
        }
        if (!this.runningOnUIThread() && this.runningOnMainThread()) {
            runnable.run();
        } else {
            this.m_MainThreadJobs.add(runnable);
        }
    }

    protected void executeMainThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_MainThreadJobs.poll()) != null) {
            runnable.run();
        }
    }

    protected String getKeyboardLayout() {
        Object object = ((InputMethodManager)((UnityPlayer)object).mContext.getSystemService("input_method")).getCurrentInputMethodSubtype();
        if (object == null) {
            return null;
        }
        String string = C.a((InputMethodSubtype)object);
        if (string != null && !string.equals("")) {
            return string;
        }
        UnityPlayer unityPlayer = object;
        object = unityPlayer.getMode();
        return (String)object + " " + unityPlayer.getExtraValue();
    }

    abstract void onOrientationChanged(int var1, int var2);

    public abstract void setMainSurfaceViewAspectRatio(float var1);

    public abstract boolean runningOnMainThread();

    abstract void cleanupResourcesForDestroy();

    abstract void hidePreservedContent();

    public FrameLayout getFrameLayout() {
        return this.m_FrameLayout;
    }

    String getState() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mState.toString() + "\n");
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.m_AudioVolumeHandler;
        stringBuilder.append(String.format("m_AudioVolumeHandler = %b", objectArray2) + "\n");
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = this.m_OrientationLockListener;
        stringBuilder.append(String.format("m_OrientationLockListener = %b", objectArray2) + "\n");
        return stringBuilder.toString();
    }
}

