/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import com.unity3d.player.IPermissionRequestCallbacks;
import com.unity3d.player.IUnityPermissionRequestSupport;
import com.unity3d.player.PermissionRequest;

public class UnityPermissions {
    private static final String SKIP_DIALOG_METADATA_NAME = "unityplayer.SkipPermissionsDialog";

    private static boolean checkInfoForMetadata(PackageItemInfo packageItemInfo) {
        try {
            return packageItemInfo.metaData.getBoolean(SKIP_DIALOG_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean skipPermissionsDialog(Activity activity) {
        block8: {
            block7: {
                PackageManager packageManager;
                try {
                    packageManager = activity.getPackageManager();
                }
                catch (Exception exception) {}
                Activity activity2 = activity;
                activity = packageManager.getActivityInfo(activity.getComponentName(), 128);
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(activity2.getPackageName(), 128);
                if (UnityPermissions.checkInfoForMetadata((PackageItemInfo)activity)) break block7;
                if (!UnityPermissions.checkInfoForMetadata((PackageItemInfo)applicationInfo)) break block8;
            }
            return true;
        }
        return false;
    }

    public static boolean hasUserAuthorizedPermission(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    public static void requestUserPermissions(Activity activity, String[] stringArray, IPermissionRequestCallbacks iPermissionRequestCallbacks) {
        if (activity != null && stringArray != null && stringArray.length != 0) {
            if (activity instanceof IUnityPermissionRequestSupport) {
                ((IUnityPermissionRequestSupport)activity).requestPermissions(new PermissionRequest(stringArray, iPermissionRequestCallbacks));
            } else {
                activity.requestPermissions(stringArray, 96489);
            }
            return;
        }
    }

    static boolean shouldShowRequestPermissionRationale(Activity activity, String string) {
        return activity.shouldShowRequestPermissionRationale(string);
    }
}

